const WebSocket = require("ws");

// 创建 WebSocket 服务器，监听 8080 端口
const wss = new WebSocket.Server({ port: 8080 });

console.log("WebSocket 服务器已启动，监听 ws://localhost:8080");

// 当有客户端连接时
wss.on("connection", (ws) => {
    console.log("新客户端已连接");

    const data = createData()
    if (ws.readyState === WebSocket.OPEN) {
        ws.send(JSON.stringify(data));
    }

    // 设置定时器发送数据
    const intervalId = setInterval(() => {
        const data = createData(1000, 1)
        if (ws.readyState === WebSocket.OPEN) {
            ws.send(JSON.stringify(data));
        }
    }, 2000);

    // 当客户端断开连接时
    ws.on("close", () => {
        console.log("客户端已断开连接");
        clearInterval(intervalId); // 清除定时器
    });
});

function formatDate(date, format) {
    const pad = (num) => num.toString().padStart(2, '0');

    return format
        .replace('HH', pad(date.getHours()))
        .replace('mm', pad(date.getMinutes()))
        .replace('ss', pad(date.getSeconds()));
}

// 生成模拟波形数据
function createData(
    count = 40000,
    dataCount = 1,
    minValue = 50,
    maxValue = 250
) {
    const result = []
    const now = new Date()

    // 生成时间点（从当前时间往前递减）
    const timeStamps = []
    for (let i = count - 1; i >= 0; i--) {
        const time = new Date(now.getTime() - i * 1000)
        timeStamps.push(time)
    }

    // 初始化各数据项的值和方向
    const dataValues = {}
    const dataDirections = {}

    for (let i = 1; i <= dataCount; i++) {
        const key = `data${i}`
        dataValues[key] = minValue + Math.random() * (maxValue - minValue) // 初始随机值
        dataDirections[key] = Math.random() > 0.5 ? 1 : -1 // 随机初始方向
    }

    for (let i = 0; i < count; i++) {
        const item = { name: formatDate(timeStamps[i], 'HH:mm:ss') }

        // 为每个数据项生成波形数据
        for (let j = 1; j <= dataCount; j++) {
            const key = `data${j}`
            const change = 10 + Math.random() * 30 // 变化幅度10~40（可调整）

            // 随机决定是否改变方向（更自然的波动）
            if (Math.random() < 0.2) {
                // 20%概率改变方向
                dataDirections[key] *= -1
            }

            dataValues[key] += dataDirections[key] * change

            // 限制在合理范围内（但不强制反转）
            dataValues[key] = Math.max(
                minValue * 0.9, // 允许稍微低于最小值（避免卡边界）
                Math.min(maxValue * 1.1, dataValues[key]) // 允许稍微高于最大值
            )

            item[key] = Math.round(dataValues[key])
        }

        result.push(item)
    }

    return result
}