#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <termios.h>
#include <sys/types.h>
#include <poll.h>
#include "my_easylogging.h"
int ttyfd;
int stdout_changed = 0;
int tty_changed = 0;
struct termios stdout_tio;
struct termios tty_tio;
using namespace std;

string get_sim_num();
int set_blue_alarm_led(int value);

int main(int args, const char *argv[])
{
    // if (args != 2)
    // {
    //     fprintf(stderr, "Usage: ./sendat ttyUSB\n");
    //     exit(EXIT_FAILURE);
    // }
    easylogginginit(); //日志初始化
    // get_sim_num();
    set_blue_alarm_led(1);
    return 0;
}
/**
 * @brief Get the sim num object
 * 获取sim卡号 若格网关
 * @return string
 */
string get_sim_num()
{
    string sim_num;

    char readbuf[256];
    ttyfd = open("/dev/ttyUSB1", O_RDWR | O_NOCTTY | O_NDELAY);
    if (ttyfd < 0)
    {
        perror("open");
        exit(EXIT_FAILURE);
    }
    int ret = write(ttyfd, "AT+ICCID\r\n", 10);
    if (ret < 0)
    {
        perror("write");
        exit(EXIT_FAILURE);
    }
    usleep(100 * 1000);

    ret = read(ttyfd, readbuf, sizeof(readbuf));
    if (ret < 0 && errno != EAGAIN)
    {
        perror("read");
        exit(EXIT_FAILURE);
    }
    // LOG(INFO) << "ret = " << ret;

    LOG(INFO) << "readbuf =" << readbuf;

    for (int i = 0; i < ret; i++)
    {
        if (readbuf[i] >= 0x30 && readbuf[i] <= 0x39)
        {
            sim_num.push_back(readbuf[i]);
        }
    }
    LOG(INFO) << "sim_num = " << sim_num;
    LOG(INFO) << "sim_num.size  = " << sim_num.size();

    // if (ret > 0)
    //     write(ttyfd, "AT+ICCID\r\n", 10);
    // sim_num =to_string()
    return sim_num;
}
/*
+ICCID: 89860621330066521767

OK
*/

/**
 * @brief Set the red alarm led object
 * 蓝色表示 柴油发电机 水温高报警
 * 报警灯的黄色接到 网关DO2端 echo 1 > /sys/class/gpio/gpio53/value
 * @param  value           1 启动  0关闭
 * @return string
 */
int set_blue_alarm_led(int value)
{
    // string diesel_oil_level_sensor_2_status;
    // char readbuf[256];
    int ttyfd = open("/sys/class/gpio/gpio53/value", O_RDWR);
    if (ttyfd < 0)
    {
        return 0;
    }

    if (value > 0)
    {
        //开启报警灯
        int ret = write(ttyfd, "1", 1);
        if (ret < 0)
        {
            close(ttyfd);
            return 0;
        }
    }
    else
    {
        // 关闭报警灯
        int ret = write(ttyfd, "0", 1);
        if (ret < 0)
        {
            close(ttyfd);
            return 0;
        }
    }

    close(ttyfd);
    return 0;
}