import sys
import os
import configparser
from enum import Enum

class SystemID(Enum):
    Server = 1
    UI = 2
    Device = 3
    AGI = 4
    OAM = 5

class ParserStartIni():

    def __init__(self, path = os.getcwd()):
        self.path = path

    def SetIniPath(self, path):
        self.path = path

    def Read(self):
        self.cfg = configparser.ConfigParser()
        try:
            self.cfg.read(self.path+"/blueocean.ini")
            return True
        except:
           return False 

    def SUIDHeaderInt(self):
        suid = int(self.cfg["role"]["level1"]) << 28 | int(self.cfg["role"]["level2"]) << 24 | int(self.cfg["role"]["level3"]) << 20 
        return suid

    def LocalMqtt(self):
        return [self.cfg["mqtt-local"]["server"], int(self.cfg["mqtt-local"]["port"])]

    def CloudMqtt(self):
        return [self.cfg["mqtt-cloud"]["server"], int(self.cfg["mqtt-cloud"]["port"])]


class ParserSUID():

    def __init__(self, suid = 0):
        self.suid = hex(suid)

    def SetSUID(self, suid):
        self.suid = hex(suid)

    def GenSUID( self, suidheader, subsystem, submodule):
        self.suid = hex(suidheader|subsystem<<16|submodule<<12)

    def GetPubTopic(self, level):
        self.suidstr = str(self.suid)
        return '/'+'/'.join(str(self.suid)[2:2+level])

    def GetSubTopic(self, level):
        self.suidstr = str(self.suid)
        return '/'+'/'.join(str(self.suid)[2:2+level])


