# This Python file uses the following encoding: utf-8
import os
from pathlib import Path
import sys

from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QApplication, QGraphicsView, QMainWindow
from drawtest import Ui_MainWindow
from enum import Enum

# 自定义QGraphics
from CustomItem import CustomItem, ShapeType
from CustomScene import CustomScene
from CustomView import CustomView, Operation

class MyWindow(QMainWindow, Ui_MainWindow):
    def __init__(self):
        super(MyWindow, self).__init__()
        self.setupUi(self)
        self.graphicsView = CustomView(image="0.png", background="0x222222")
        self.graphicsView.setObjectName("graphicsView")
        self.horizontalLayout_6.addWidget(self.graphicsView)
        self.pushButton.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_Rectangle))
        self.pushButton_2.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_Ellipse))
        self.pushButton_3.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_Angle))
        self.pushButton_4.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_Line))
        self.pushButton_5.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_Polygon))
        self.pushButton_6.clicked.connect(lambda: self.set_shape_type(ShapeType.ShapeType_PolygonLine))
        self.pushButton_11.clicked.connect(lambda: self.set_operation(Operation.Operation_DEFAULT))

    def set_shape_type(self, shape_enum):
        # 设置绘图模式
        self.graphicsView.set_operation(Operation.Operation_IMAGE_DRAW, shape_enum)

    def set_operation(self, operation):
        self.graphicsView.set_operation(operation, ShapeType.ShapeType_Null)


if __name__ == "__main__":
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec())