import zmq

def double_server(server_url="tcp://*:5555"):
    context = zmq.Context()
    socket = context.socket(zmq.REP)
    socket.bind(server_url)
    print("server started...")
    while True:
        req = socket.recv()
        print ("server received request %s " % req)
        result = str(2*int(req))
        socket.send(result)
        print("server replied with %s" % result)

if __name__ == "__main__":
    double_server()
