import time
import zmq
import datastruct_pb2
from google.protobuf import json_format

context = zmq.Context()
socket = context.socket(zmq.REP)
socket.bind("tcp://*:10020")

while True:
    # wait for next request from client
    message = socket.recv()
    
    tdsfull = datastruct_pb2.TDSDataFullSync()
    tdsfull.ParseFromString(message)
    print("Recived request :%s " % json_format.MessageToJson(tdsfull))

    netcfg = datastruct_pb2.NetworkConfiguration()
    
    for item in tdsfull.Data:
        print(datastruct_pb2.TDSData.TID.Name(item.TableId))
        for table in item.Data:
            table.Unpack(netcfg)
            print(datastruct_pb2.NetworkConfiguration.PROTOCOL.Name(netcfg.Protocol))

    #Do some work

    time.sleep(1)

    socket.send(b"word");

