# easy_logging 模块说明

## loguru 说明
这个模块就是在 loguru 的基础上进行了封装，主要是为了方便使用，不用每次都要写一大堆的代码，只需要一行代码就可以输出日志。

如果不适用这个模块，可以直接使用 loguru 模块，但是想用相关的输出样式，可以参考下面的代码
    
```python
import sys
from loguru import logger
# 清空所有设置
logger.remove()
# 添加控制台输出的格式,sys.stdout为输出到屏幕;关于这些配置还需要自定义请移步官网查看相关参数说明
logger.add(sys.stdout,
           format="<green>{time:YYYYMMDD HH:mm:ss}</green> | "  # 格式化打印
                  "{process.name} | "  # 进程名
                  "{thread.name} | "  # 进程名
                  "<cyan>{module}</cyan>.<cyan>{function}</cyan>"  # 模块名.方法名
                  ":<cyan>{line}</cyan> | "  # 行号
                  "<level>{level}</level>: "  # 等级
                  "<level>{message}</level>",  # 日志内容
           enqueue=True,  # 异步
           backtrace=True,  # 回溯
           diagnose=True,  # 诊断
           )

# 输出到文件的格式,注释下面的add',则关闭日志写入
logger.add(log_file_path,
           level="DEBUG",           # 输出到文件的日志最低等级
           format="{time:YYYYMMDD HH:mm:ss} | "  # 时间
                  "{process.name} | "  # 进程名
                  "{thread.name} | "  # 进程名
                  "{module}.{function}:{line} | "  # 模块名.方法名:行号
                  "{level}: | "  # 等级
                  "{message}",
           rotation="10 MB",
           enqueue=True,
           encoding='utf-8')
```


## easy_logging 说明

日志等级一共有五个等级，分别是：DEBUG、INFO、WARNING、ERROR、EXCEPTION。
运行同级目录下的 main.py 文件可查看输出结果。
![img.png](img/img.png)

* 其中 EXCEPTION 可以回溯到异常发生的位置，并输出相关信息。
![img_1.png](img/img_1.png)

* 此外还提供了注解 `@Logger.catch`，可将其放在函数名的上一行，用于捕获异常并输出相关信息，效果和 EXCEPTION 相同。
![img_2.png](img/img_2.png)

### 使用方法

```python
from easy_logging import Logger

Logger.info(11111)
Logger.debug(222222)
Logger.warning(333333)
Logger.error(444444)
Logger.exception(555555)

@Logger.catch
def cal1(x, y, z):
    return x * y / z
```

### 输出日志文件说明

默认的输出日志文件为 `log.txt`，可在 `my_logging.py` 文件中修改，或在模块的`__init__.py`文件中修改。

日志等级从低到高分别是：DEBUG < INFO < WARNING < ERROR < EXCEPTION。

控制日志输出的代码段为，如果不需要显示 DEBUG 级别的日志，可将 `level='DEBUG'` 改为 `level='INFO'`。以此类推。
```python
self.logger.add(log_file_path,
                level='DEBUG',
                format="{time:YYYYMMDD HH:mm:ss} | "  # 时间
                       "{process.name} | "  # 进程名
                       "{thread.name} | "  # 进程名
                       "{module}.{function}:{line} | "  # 模块名.方法名:行号
                       "{level}: | "  # 等级
                       "{message}",
                rotation="10 MB",
                enqueue=True,
                encoding='utf-8')
```



