## 准备阶段，使用navicat工具辅助
1、使用navicat，输入mysql相关参数进行连接
2、进入mysql，使用navicat创建数据库
3、创建数据表，使用编写好的.sql文件进行创建数据表，考虑到海洋项目的数据库同步情况，建表时一般不使用自增字段
4、使用 sqlacodegen 命令生成 model
```shell
# mysql+pymysql://root:lhr@192.168.0.210:3306/test  mysql数据库相关参数：用户名，密码，ip，端口，数据库名称
# --outfile=./spec/ormtables/tables.py 输出目录，相对路径，已实际为准
sqlacodegen mysql+pymysql://root:lhr@192.168.0.210:3306/test  --outfile=./spec/ormtables/tables.py 
```
5、在自动生成的tables.py文件中，为每个类添加get_pk()方法，用于update时去除主键，包含主键进行update会报错
```python
def get_pk(self):
    return ['norad']
```
6、在自动生成的tables.py文件中，为Base类重写方法
```python
# 将对象可以转化为 dict 类型
def to_dict(self):
    return {c.name: getattr(self, c.name, None)
            for c in self.__table__.columns}


Base.to_dict = to_dict
```
7、关于数据库导入导出
- 有mysql环境的话，使用mysqldump -h 192.168.0.210 -u root -P 3306 -p test > ./ttst.sql  #h--ip,u--root,P--端口,-p 数据库有密码的话该项必填，test 数据库名称
- 如果只是表结构，应查看创建数据库时使用的.sql文件；如果需要导出数据 navicat使用导出向导功能，导出.sql文件，需要注意自增字段，不能直接插入新的数据库 

## 基于sqlalchemy，编写的公共代码
./feature/mysql/sqlkit.py
可实现单个添加，批量添加，修改（根据条件实现单个或多个操作），删除（根据条件实现单个或多个操作），查询，双表查询

## 关于 sqlalchemy filter 参数
多个条件时使用以下函数实现
and_()
or_()
```python
from sqlalchemy import and_

and_(SatelliteWork.norad== sat.norad , SatelliteWork.config_id==1)
or_(SatelliteWork.norad== sat.norad , SatelliteWork.config_id==1)
```

## 测试用例
.\test\public-mysql-test\public_mysql_test.py
