from __future__ import annotations
from configparser import ConfigParser  # Python2中是from ConfigParser import ConfigParser


def new(path: str, encoding: str | None):
    conf = ConfigParser()  # 需要实例化一个ConfigParser对象
    if path != '':
        conf.read(path, encoding=encoding)
    return conf


def read(conf: ConfigParser, path: str):
    conf.read(path)


def get(conf: ConfigParser, section: str, key: str, t: type):
    if t is int:
        return conf[section].getint(key)
    elif t is float:
        return conf[section].getfloat(key)
    elif t is bool:
        return conf[section].getboolean(key)
    else:
        return conf[section].get(key)
