import zmq
import random
import time

raw_input = input
context = zmq.Context()

sender = context.socket(zmq.PUSH)
sender.bind("tcp://*:5555")

sink = context.socket(zmq.PUSH)
sink.connect("tcp://localhost:6666")

if __name__ == '__main__':
    print("Press Enter when the workers are ready: ")
    _ = raw_input()
    print("Sending tasks to workers…")
    sink.send_string('0')
    time.sleep(1)
    total_msec = 0
    for task_nbr in range(30):
        workload = random.randint(1, 5)
        total_msec += workload
        sender.send_string(u'index %d,%d' % (task_nbr, workload))
    print("30个任务的总工作量: %s 秒" % total_msec)

