# Readme

main.py是项目主入口，加载MainWindow，个人测试代码直接存放到test目录中，先在test中进行充分测试，再考虑移动到其他目录

pycharm设置当前工程为`Sources root`目录很重要，避免自定义文件导入的时候要添加路径<br/>
**File --> Mark Directory as --> Sources root**

linux 下类似的命令则为:`export PYTHONPATH=$PYTHONPATH:xxxxxx`

## 目录说明：

.<br/>
├── cmm 公共功能存放该目录，例如SUID解析都需要用到<br/>
├── docs 存放开发文档、学习文档分享<br/>
├── download 下载第三方实例<br/>
├── feature 特性目录存放mongodb、mysql、zmq 通信、数据库操作模块<br/>
├── ini 存放配置文件<br/>
├── script pycharm开发环境忽略,linux方便启动conda环境,通过`source activate_env.sh`激活, 具体路径修改脚本<br/>
├── spec 规格文件存放proto定义<br/>
├── system 逻辑实现、整合， 子系统实现<br/>
├── test 存放测试代码<br/>
└── ui 该目录下的文件跟Qt Designer相关，有UI/ICON/StyleSheet<br/>


## 开发环境安装  
- 1、先安装miniconda
- 2、创建基础python环境，基于3.9版本 
   `conda create -n xxxx python=3.9`
- 3、直接导入 requirement.txt 文件恢复库文件，该文件在script目录中
   `pip install -i https://pypi.douban.com/simple/ -r requirement.txt`
- 4、pip安装包列表导出，如果有新的安装包下载到conda环境中，导出到requirement.txt文件
   `pip freeze > requirement.txt`

**AES文件加密与恢复 pip install pycryptodome**

## 常用命令
- 1、设计师编辑ui文件：
designer.exe

- 2、将ui文件变为py文件
pyuic5.exe -o .\mainwindow.py .\mainwindow.ui

- 3、将qrc文件变为py文件
pyrcc5.exe -o .\image_rc.py .\image.qrc

> 两个工具在miniconda脚本目录中  C:\TOOLS\miniconda3\Scripts\pyuic5.exe
> 两个工具在miniconda脚本目录中  C:\TOOLS\miniconda3\Scripts\pyrcc5.exe
可能在其他目录，上述命令可以设置到pycharm扩展工具方便调用
 

## 国际化

- 1、国际化先变ts
pylupdate5.exe .\imageprocess.py -ts zh.ts

- 2、打开语言家打开ts文件完成翻译保存为qm：
linguist.exe

> 当我们的ts文件损坏或者丢失时，可以根据qm文件反生成ts文件，使用如下的命令： 
lconvert compiled.qm -o source.ts 

> 将多个ts文件合并输出
lconvert -i primary.ts secondary.ts -o complete.ts 

