# Python编码规范

## 命名规则

|Python的名称类型|	示例|	注释|
|----|----|----|
|变量名|	name_str|	全小写加下划线（lower_with_under）or 类的成员变量前加`m_`明确标识|
|常量名|	NAME_STR|	全大写加下划线（UPPER_WITH_UNDER）|
|函数名|	def convert_name():|	全小写加下划线（def lower_with_under()）
|类名|	class NameConvertor():|	驼峰式加首字母大写，一般是名词（class CapitalWords()）|
|模块名|	convert_name.py|	全小写加下划线（lower_with_under.py）|
|包名（文件夹名）|	convert_name|	全小写加下划线的文件夹名称，记得必须加__init__.py文件哦（lower_with_under）|

> 变量也是小写下划线，类的成员变量前加`m_`明确标识, 类似于C++风格

其他语句代码块规则
语句代码涉及比如运算符和表达式，语句换行，tab缩进等参考Pycharm中提示的PEP8(Python 代码风格指南)，有提示划线的地方都可以优化

Pycharm的：Ctrl + Alt + L 格式化代码

``` text
tip

module_name, package_name, ClassName, method_name, ExceptionName,

function_name, GLOBAL_VAR_NAME, instance_var_name,

function_parameter_name, local_var_name.
```

### !应该避免的名称

* 单字符名称, 除了计数器和迭代器.
* 包/模块名中的连字符(-)
* 双下划线开头并结尾的名称(Python保留, 例如__init__)

### 命名约定

* 所谓"内部(Internal)"表示仅模块内可用, 或者, 在类内是保护或私有的.用单下划线(_)开头表示模块变量或函数是protected的(使用import *from时不会包含).
* 用双下划线(__)开头的实例变量或方法表示类内私有.将相关的类和顶级函数放在同一个模块里. 不像Java,没必要限制一个类一个模块.

* 对类名使用大写字母开头的单词(如CapWords, 即Pascal风格),但是模块名应该用小写加下划线的方式(如lower_with_under.py).尽管已经有很多现存的模块使用类似于CapWords.py这样的命名,但现在已经不鼓励这样做, 因为如果模块名碰巧和类名一致,这会让人困扰.

## 代码注释
> 类定义或者函数注释，pycharm打开Settings->Tools->Python Integrated Tools->Docstring format 改为reStructuredText;然后在函数声明下面输入"""回车即可生成函数注释模板，如下：

```python
class ThreadExit(object):
    def __init__(self):
        """
        __init_ ThreadExit
        """
        self.m_event = threading.Event()
        self.m_thread = None

    def init(self, param1, param2, param3):
        """
        this is only for example~
        :param param1:
        :param param2:
        :param param3:
        :return:
        """
        self.m_thread = threading.Thread(target=self.runtine)
```

## 特殊约定

* 代码一行不超过80字符，通过()隐式连接，不用反斜杠；注释可以超过。
```python
Yes: foo_bar(self, width, height, color='black', design=None, x='foo',
             emphasis=None, highlight=0)

     if (width == 0 and height == 0 and
         color == 'red' and emphasis == 'strong'):
```

* 条件语句和返回语句中尽量不用括号，除非特别指明优先级
* 顶级定义之间空两行，函数定义之间空一行
* 类不继承其他类可以继承object基础类
* 在if __name__ == '__main__':条件下写入测试代码，如此可以避免测试代码在模块被导入后执行。


## Python之父Guido推荐的规范

|Type	|Public	|Internal|
|  ----  | ----  |----|
|Modules|	lower_with_under|	_lower_with_under|
|Packages|	lower_with_under||	
|Classes|	CapWords|	_CapWords|
|Exceptions|	CapWords||	
|Functions|	lower_with_under()|	_lower_with_under()|
|Global/Class Constants|	CAPS_WITH_UNDER|	_CAPS_WITH_UNDER|
|Global/Class Variables|	lower_with_under|	_lower_with_under|
|Instance Variables|	lower_with_under|	_lower_with_under (protected) or __lower_with_under (private)
|Method Names|	lower_with_under()|	_lower_with_under() (protected) or __lower_with_under() (private)
|Function/Method| Parameters|	lower_with_under|	
|local Variables|	lower_with_under||	