# This Python file uses the following encoding: utf-8
import os
from pathlib import Path
import sys
from PyQt5.QtCore import QPointF, Qt, QRectF, QSizeF, QT_VERSION_STR, QSize, QLineF
from PyQt5.QtGui import QPainter, QColor, QImage, QPixmap, QWindow, QIcon, QPolygonF, QPen, QCursor, QBrush, QFont
from PyQt5.QtWidgets import QApplication, QGraphicsView, QMainWindow, QGraphicsPixmapItem, QGraphicsScene
from PyQt5.QtWidgets import QGraphicsEllipseItem, QGraphicsSimpleTextItem, QGraphicsObject, QGraphicsItem
from PyQt5.QtWidgets import QPushButton, QLabel, QSlider, QFileDialog
from PyQt5.QtWidgets import QWidget, QGroupBox, QLineEdit, QSizePolicy
from PyQt5.QtWidgets import QHBoxLayout, QVBoxLayout, QGridLayout
from PyQt5.QtWidgets import QListWidgetItem
from PyQt5.QtCore import QObject, pyqtSignal
from enum import Enum


class OPERATIONCODE(Enum):
    DEFAULT = 0
    WINDOW_GRID = 1
    IMAGE_MOVE = 2
    IMAGE_ZOOM = 3
    IMAGE_WL = 4
    IMAGE_ROATE = 5
    IMAGE_RESTORE = 6
    IMAGE_PAGE = 7
    IMAGE_DISPLAY = 8
    IMAGE_SHOT = 9
    IMAGE_EXPORT = 10
    IMAGE_DRAW = 11


class SHAPE_TYPE(Enum):
    SHAPE_TYPE_Null = 0
    SHAPE_TYPE_Rectangle = 1
    SHAPE_TYPE_Ellipse = 2
    SHAPE_TYPE_Line = 3
    SHAPE_TYPE_Angle = 4
    SHAPE_TYPE_Delete = 5

class CustomRuler(QGraphicsObject):
    def __init__(self, type):
        super(CustomRuler, self).__init__()
        self.m_style = type
        self.m_ptZero = QPointF(0,0)
        self.m_qsUnit = "mm"
        self.m_fInterval = 4.0
        self.m_fZoom = 1.0

    def paint(self, painter, option, widget):
        if self.draw_enable == True:
            mPen = QPen(Qt.GlobalColor.green)
            mPen.setWidth(3)
            painter.setPen(mPen)
            painter.setFont(QFont("宋体", 35, 1))
            painter.drawLine(self.m_line)

        #抗锯齿绘制
        painter.setRenderHint(QPainter.RenderHint.Antialiasing)
        if self.m_style == Qt.Horizontal:
            #绘制水平刻度尺
            self.DrawHorizontalScale(painter, pen)
        else:
            #绘制垂直刻度尺
            self.DrawVerticalScale(painter, pen)

    def DrawHorizontalScale(self, painter, pen):
        #TODO：绘制，水平刻度尺
        #绘制一条水平坐标线
        ptBegin = QPointF(self.m_ptZero.x(), self.m_ptZero.y())
        ptEnd = QPointF(self.rect().width(), self.m_ptZero.y())

        painter.drawLine(ptBegin, ptEnd)
        #绘制刻度线
        fDrawLeft = self.m_ptZero.x()
        nIndex = 0

        # 刻度线高度
        nScaleHeight = 20
        while fDrawLeft < self.rect().width():
            if (nIndex % 2 == 0) and (nIndex % 5 == 0):
                pen.setWidth(2)
                painter.setPen(pen)
                #绘制刻度值
                nScaleHeight = 15
                #绘制文本
                sText = str(nIndex / 10) + self.m_qsUnit
                painter.drawText(QPointF(fDrawLeft, self.m_ptZero.y() + nScaleHeight + 15), sText)
            else:
                pen.setWidth(1)
                painter.setPen(pen)
                #当是中间节点时，长度要比一般的长
                if nIndex % 5 == 0:
                    nScaleHeight = 10
                else:
                    nScaleHeight = 6
            # 绘制刻度值
            painter.drawRect(QRectF(fDrawLeft, self.m_ptZero.y(), 0.1, nScaleHeight));
            fDrawLeft += self.m_fInterval * self.m_fZoom
            nIndex = nIndex + 1

    def DrawVerticalScale(self, painter, pen):

        #TODO：绘制，垂直刻度尺
        pen.setWidth(2)
        painter.setPen(pen)
        # 绘制一条垂直坐标线

        ptBegin = QPointF(self.m_ptZero.x(), 0)
        ptEnd = QPointF(self.m_ptZero.x(), self.m_ptZero.y())
        painter.drawLine(ptBegin, ptEnd)

        # 绘制刻度线，自下向上绘制刻度值
        fDrawTop = ptEnd.y()
        nIndex = 0
        nScaleWidth = 20 # 刻度线宽度
        while fDrawTop >= 0:
            if (nIndex % 2 == 0) and (nIndex % 5 == 0):
                pen.setWidth(2)
                painter.setPen(pen)
                # 绘制刻度值
                nScaleWidth = 15
                # 绘制文本
                sText = str(nIndex / 10) + self.m_qsUnit
                fontWidth = self.fontMetrics().width(sText)
                nleft = ((self.m_ptZero.x() - nScaleWidth) - fontWidth) / 2
                painter.drawText(QPointF(nleft, fDrawTop), sText)
            else:
                pen.setWidth(1)
                painter.setPen(pen)
                # 当是中间节点时，长度要比一般的长
                if (nIndex % 5) == 0:
                    nScaleWidth = 10
                else:
                    nScaleWidth = 6

            # 绘制刻度值
            painter.drawRect(QRectF(self.m_ptZero.x() - nScaleWidth, fDrawTop, nScaleWidth, 0.1))

            fDrawTop -= self.m_fInterval * self.m_fZoom
            nIndex = nIndex + 1

    def resizeEvent(self, event):
        if self.m_style == Qt.Horizontal:
            nLeft = self.width()/28
            self.m_ptZero.setX(45)
            self.m_ptZero.setY(1)
        else:
            nLeft = self.width() - 1
            self.m_ptZero.setX(nLeft)
            self.m_ptZero.setY(self.height() -1)
        nCalcInterval = self.width()/320.0
        if nCalcInterval <= 4:
            self.m_fInterval = 4.0
        else:
            self.m_fInterval = nCalcInterval


        super(CustomRuler, self).resizeEvent(event)
