import sys
from loguru import logger

my_log_file_path = "log.txt"


class EasyLogger:
    def __init__(self, log_file_path=my_log_file_path):
        self.logger = logger

        # 清空所有设置
        logger.remove()
        # 添加控制台输出的格式,sys.stdout为输出到屏幕;关于这些配置还需要自定义请移步官网查看相关参数说明
        logger.add(sys.stdout,
                   format="<green>{time:YYYYMMDD HH:mm:ss}</green> | "  # 颜色>时间
                          "{process.name} | "  # 进程名
                          "{thread.name} | "  # 进程名
                          "<cyan>{module}</cyan>.<cyan>{function}</cyan>"  # 模块名.方法名
                          ":<cyan>{line}</cyan> | "  # 行号
                          "<level>{level}</level>: "  # 等级
                          "<level>{message}</level>",  # 日志内容
                   enqueue=True,  # 异步
                   backtrace=True,  # 回溯
                   diagnose=True,  # 诊断
                   )

        # 输出到文件的格式,注释下面的add',则关闭日志写入
        logger.add(log_file_path,
                   level="DEBUG",
                   format="{time:YYYYMMDD HH:mm:ss} | "  # 时间
                          "{process.name} | "  # 进程名
                          "{thread.name} | "  # 进程名
                          "{module}.{function}:{line} | "  # 模块名.方法名:行号
                          "{level}: | "  # 等级
                          "{message}",
                   rotation="10 MB",
                   enqueue=True,
                   encoding='utf-8')

    def get_instance(self):
        return self.logger

    def info(self, msg, *args, **kwargs):
        return self.logger.info(msg, *args, **kwargs)

    def debug(self, msg, *args, **kwargs):
        return self.logger.info(msg, *args, **kwargs)

    def warning(self, msg, *args, **kwargs):
        return self.logger.warning(msg, *args, **kwargs)

    def error(self, msg, *args, **kwargs):
        return self.logger.error(msg, *args, **kwargs)

    def exception(self, msg, *args, **kwargs):
        return self.logger.exception(msg, *args, **kwargs)

    def catch(self, *args, **kwargs):
        return self.logger.catch(*args, **kwargs)


Logger = EasyLogger().get_instance()


