import sys
from loguru import logger


# 清空所有设置
logger.remove()
# 添加控制台输出的格式,sys.stdout为输出到屏幕;关于这些配置还需要自定义请移步官网查看相关参数说明
logger.add(sys.stdout,
           format="<green>{time:YYYYMMDD HH:mm:ss}</green> | "  # 颜色>时间
                  "{process.name} | "  # 进程名
                  "{thread.name} | "  # 进程名
                  "<cyan>{module}</cyan>.<cyan>{function}</cyan>"  # 模块名.方法名
                  ":<cyan>{line}</cyan> | "  # 行号
                  "<level>{level}</level>: "  # 等级
                  "<level>{message}</level>",  # 日志内容
           enqueue=True,  # 异步
           backtrace=True,  # 回溯
           diagnose=True,  # 诊断
           )




