# 	HSL- 5G 网关运行环境搭建

[!!!先备份一下开发板的 /home/root/下的内容以备不时之需!!!]

## 1、安装.net5

https://dotnet.microsoft.com/download/dotnet/5.0

在root备份下的dotnet5也可以直接拷贝到/home/root下

## 2、增加libstdc++库

https://releases.linaro.org/components/toolchain/binaries/6.3-2017.05/aarch64-linux-gnu/

下载文件

```
sysroot-glibc-linaro-2.23-2017.05-aarch64-linux-gnu.tar.xz
```

可以在备份的/home/root/sysroot 下找到不用下载

## 3、修改配置文件 

/etc/profile ，在最后增加下面环境变量，前面两条是.net5的环境变量，第三四两个是.net5的两个配置开关，需要打开否则会报错
[最后一个是增加新的动态链接库，指向我们下载的位置]
不应该将所有的库加入到连接路径，目前的操作是将libstdc++.so.6.0.22拷贝到/usr/lib/下

```
export DOTNET_ROOT=$HOME/dotnet5
export PATH=$PATH:$HOME/dotnet5
export DOTNET_SYSTEM_GLOBALIZATION_INVARIANT=true
export DOTNET_CLI_TELEMETRY_OPTOUT=true
#export LD_LIBRARY_PATH=/home/root/sysroot/sysroot-glibc-linaro-2.23-2017.05-aarch64-linux-gnu/lib
```

#先删除原有的，再改成新的

```
ln -s libstdc++.so.6.0.22 libstdc++.so.6

root@ls1012a-ek200:/usr/lib# ls -l |grep libstdc++ 
lrwxrwxrwx 1 root root        19 May  4 00:37 libstdc++.so.6 -> libstdc++.so.6.0.22
-rwxr-xr-x 1 1000 pulse  1061528 Dec 21  2018 libstdc++.so.6.0.20
-rwxr-xr-x 1 root root  11928128 May  4 00:35 libstdc++.so.6.0.22
root@ls1012a-ek200:/usr/lib# 
```



## 4、安装hsl

将群里面的压缩包解压后放到开发板的/home/root下面

```
chmod +x HslTechnology.EdgeServer

./HslTechnology.EdgeServer

root@ls1012a-ek200:~/linux-arm64# ./HslTechnology.EdgeServer
[Info] 2020-05-04 00:53:51.002 Thread [001]  
[Info] 2020-05-04 00:53:51.043 Thread [001]       ___            ___            ___  
[Info] 2020-05-04 00:53:51.043 Thread [001]      /\__\          /\  \          /\__\ 
[Info] 2020-05-04 00:53:51.043 Thread [001]     /:/  /         /::\  \        /:/  / 
[Info] 2020-05-04 00:53:51.043 Thread [001]    /:/__/         /:/\ \  \      /:/  /  
[Info] 2020-05-04 00:53:51.043 Thread [001]   /::\  \ ___    _\:\~\ \  \    /:/  /   
[Info] 2020-05-04 00:53:51.043 Thread [001]  /:/\:\  /\__\  /\ \:\ \ \__\  /:/__/    
[Info] 2020-05-04 00:53:51.043 Thread [001]  \/__\:\/:/  /  \:\ \:\ \/__/  \:\  \    
[Info] 2020-05-04 00:53:51.043 Thread [001]       \::/  /    \:\ \:\__\     \:\  \   
[Info] 2020-05-04 00:53:51.043 Thread [001]       /:/  /      \:\/:/  /      \:\  \  
[Info] 2020-05-04 00:53:51.043 Thread [001]      /:/  /        \::/  /        \:\__\ 
[Info] 2020-05-04 00:53:51.044 Thread [001]      \/__/          \/__/          \/__/  by 杭州胡工物联科技有限公司
[Info] 2020-05-04 00:53:51.044 Thread [001]  
[Info] 2020-05-04 00:53:51.044 Thread [001] 欢迎试用24*7小时，如需采购软件，请联系QQ：200962190  Email:hsl200909163.com   微信：13516702732
[Info] 2020-05-04 00:53:51.044 Thread [001] 正在加载配置文件。
[Info] 2020-05-04 00:53:51.247 Thread [001] 当前设备配置文件路径：/home/root/linux-arm64/devices.xml
[Info] 2020-05-04 00:53:53.225 Thread [001] 运行的目录位置：/home/root/linux-arm64/
[Info] 2020-05-04 00:53:53.230 Thread [001] 运行的系统信息：Unix 4.4.98.1
[Info] 2020-05-04 00:53:53.246 Thread [001] 运行的CLR信息：5.0.12
[Info] 2020-05-04 00:53:53.247 Thread [001] 运行的计算机信息：ls1012a-ek200
[Info] 2020-05-04 00:53:53.256 Thread [001] 运行的程序版本号：1.0.4
[Error] 2020-05-04 00:53:54.286 Thread [001] HslTechnology.Edge Authorization Failed
[Info] 2020-05-04 00:53:54.709 Thread [001] MqttServer[521] : Start engine
[Debug] 2020-05-04 00:53:54.851 Thread [001] HttpServer[522] : Server Started, wait for connections
[Info] 2020-05-04 00:53:54.875 Thread [001] EdgeServices : Web服务器加载成功！
[Info] 2020-05-04 00:53:54.901 Thread [001] EdgeServices : 远程更新服务器加载成功！
[Info] 2020-05-04 00:53:54.940 Thread [001] Server Start!
[Info] 2020-05-04 00:53:56.984 Thread [008] 上传服务器的线程启动！
```



## 备份root文件

### 1. scp从linux服务器反向scp拷贝文件到我的虚拟机

```
备份 dotne5
scp -r root@192.168.0.115:/home/root/dotnet5 /root/gw200_file
```

![image-20211129121138337](5G网关运行环境搭建-正常运行.assets/image-20211129121138337.png)

```
备份 sysroot-glibc-linaro-2.23-2017.05-aarch64-linux-gnu.tar.xz
scp -r root@192.168.0.115:/home/root/sysroot/sysroot-glibc-linaro-2.23-2017.05-aarch64-linux-gnu.tar.xz /root/gw200_file
```

![image-20211129122600349](5G网关运行环境搭建-正常运行.assets/image-20211129122600349.png)

```
备份 linux-arm64
scp -r root@192.168.0.115:/home/root/linux-arm64 /root/gw200_file
```



## 5、搭建交叉编译环境

### 5.1 配置交叉编译环境

说明：交叉编译工具可使用 fsl-qoriq 或 gcc-linaro 交叉编译工具。

#### 5.1.1 安装 fsl-qoriq 交叉编译工具

1）打开到在在网盘下载的 3.开发工具/fsl-qoriq-4.9。
2）把 fsl-qoriq-glibc-x86_64-aarch64-toolchain-2.0.part1.rar 解压到当前文件夹。
3）把解压得到的 fsl-qoriq-glibc-x86_64-aarch64-toolchain-2.0.sh 文件复制到 Ubuntu Host 上。
4）执行下面的命令以开始安装交叉编译工具

```
=====> 输入指令：
./fsl-qoriq-glibc-x86_64-aarch64-toolchain-2.0.sh
```

5）选择安装路径，这里直接按 Enter 键，并在安装确认提示时还是直接按 Enter 键以继续安装。

![1638172840335](5G网关运行环境搭建-正常运行.assets/1638172840335.png)6）执行环境变量配置脚本并配置环境变量

```
=====> 输入指令：
./opt/fsl-qoriq/2.0/environment-setup-aarch64-fsl-linux
	注：若无法执行，先将文件转成可执行文件，再执行：chmod +x environment-setup-aarch64-fsl-linux
unset LDFLAGS
```

7）检查配置

```
=====> 输入指令：
echo $LDFLAGS
$CC -v
```

![1638172949350](5G网关运行环境搭建-正常运行.assets/1638172949350.png)

#### 5.1.2 安装 gcc-linaro 交叉编译工具

若无fsl-qoriq包可用方法2

1）创建安装目录

```
=====> 输入指令：
sudo mkdir /opt/gcc-linaro -p
sudo chmod 777 /opt/gcc-linaro
cd /opt/gcc-linaro
```

2）下载交叉编译工具

```
=====> 输入指令：
wget https://releases.linaro.org/components/toolchain/binaries/latest-4/aarch64-linux-gnu/gcc-linaro-4.9.4-2017.01-x86_64_aarch64-linux-gnu.tar.xz
```

3）解压交叉编译工具

```
====> 输入指令：
tar xvf gcc-linaro-4.9.4-2017.01-x86_64_aarch64-linux-gnu.tar.xz -C /opt/gcc-linaro
```

4）创建交叉编译工具配置脚本=====> 输入指令：

```
cat << EOF > /opt/gcc-linaro/gcc-linaro-4.9.4-2017.01-x86_64_aarch64-linux-gnu.env

!/bin/sh

export PATH=/opt/gcc-linaro/gcc-linaro-4.9.4-2017.01-x86_64_aarch64-linux-gnu/bin:${PATH}
export ARCH=arm64
export CROSS_COMPILE=aarch64-linux-gnu-EOF
```

5） 配置交叉编译环境变量

```
=====> 输入指令：

chmod +x /opt/gcc-linaro/gcc-linaro-4.9.4-2017.01-x86_64_aarch64-linuxgnu.env
```

6）检查安装

```
=====> 输入指令：
${CROSS_COMPILE}gcc -v
```

### 5.2测试交叉编译环境

将测试例程clone到指定文件夹

```
=====> 输入指令：

git clone http://git.linkortech.com:10020/NO.14/HelloWorld
```

测试在本虚拟机下跑通例程

```
=====> 输入指令：

source  source env_linux.sh

./build_project.sh 
```

例程可执行

![1638175089298](5G网关运行环境搭建-正常运行.assets/1638175089298.png)

source 交叉编译环境

```
=====> 输入指令：

source arm_env_linux.sh 

./build_project.sh 
```

生成可执行文件helloworld，执行该文件，提示无法执行

![1638175226411](5G网关运行环境搭建-正常运行.assets/1638175226411.png)

原因是所生成的是在aarch64架构下的可执行文件

![1638175331016](5G网关运行环境搭建-正常运行.assets/1638175331016.png)

将该可执行文件scp传输到网关中（新建zjftest文件夹）

```
=====> 输入指令：

scp hellowordl@192.168.0.115:/root/zjftest
```

在网关终端执行hellowordl可执行文件

![1638175628036](5G网关运行环境搭建-正常运行.assets/1638175628036.png)



## 6、重刷系统

### 6.1网关进入uboot命令行

网关上电，将console线的水晶头连接网关console口，usb口连接pc

打开xshell新建新连接，协议设置为serial

![1638338740271](README.assets/1638338740271.png)

串口配置参数为

![1638338763393](README.assets/1638338763393.png)

此时进入计算机设备管理器—端口（COM）—COM5（本机串口）右键属性—将串口参数改为相同设置

![1638338853283](README.assets/1638338853283.png)

返回xshell，连接串口，页面显示串口已连接，但终端内容空白

![1638338927054](README.assets/1638338927054.png)

**解决方法：**[(13条消息) CRT已经成功连接服务器，但是界面显示空白，无任何显示_随意-CSDN博客_crt连接console口时显示空白](https://blog.csdn.net/u010606602/article/details/49684369?spm=1001.2101.3001.6661.1&utm_medium=distribute.pc_relevant_t0.none-task-blog-2%7Edefault%7ECTRLIST%7Edefault-1.no_search_link&depth_1-utm_source=distribute.pc_relevant_t0.none-task-blog-2%7Edefault%7ECTRLIST%7Edefault-1.no_search_link)

连接成功

设备断电，重新上电，终端显示网关uboot信息，如下所述的版本号无需进行重新刷机

![1638339157697](README.assets/1638339157697.png)

![1638339261883](README.assets/1638339261883.png)

### 6.2更新系统

#### 6.2.1 进入内存系统

上一步查看 u-boot 环境变量 后，执行下面命令：

```
 run bootcmd_rcv
```


在输出 reading ramsys.itb 后需要等待一会。

#### 6.2.2 更新系统

在设备输出 `ls1012a-ek200 login:` 后，输入 root 登录，并执行以下命令：

```
 /run/media/sda/system_recovery.sh usb
```

系统更新过程中出现大量错误，终端提示没有以下文件和目录

![1638345890442](README.assets/1638345890442.png)

但是进入到相关目录下，可以找到对应的文件，发现是原文件夹名称不对

![1638345976175](README.assets/1638345976175.png)

解决问题，继续步骤操作

uboot中board信息与教程中不符 

![1638350839909](README.assets/1638350839909.png)

另外自动化重装过程中出现以下错误：

![1638429069060](README.assets/1638429069060.png)

![1638429258123](README.assets/1638429258123.png)

暂时不知错误的原因和影响，等技术人员答复。继续往下执行，重新上电就去uboot指令行，

```
 setenv rcv_key disable; saveenv
```

之后输入 boot 继续启动。

#### 6.2.3重新拷入文件

执行完上述重刷系统后，root目录下文件被重置，root内容如下

![1638430478517](README.assets/1638430478517.png)

将此前备份的文件用scp重新拷入

```
scp -r dotnet5 user@192.168.0.115:/root
```

在scp传输过程中出现严重警告

![1638433587781](README.assets/1638433587781.png)

**解决：**[(13条消息) IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY! 解决办法_evolve17的博客-CSDN博客](https://blog.csdn.net/weixin_44545265/article/details/88362272)

