# 基于 OpenDaylight 的三层交换机的实现

## 实验环境搭建

### Opendaylight环境搭建

环境搭建参考以下链接，按步骤基本顺利执行

[(13条消息) OpenDayLight安装_馋鱼夜炖桃的博客-CSDN博客_opendaylight安装](https://blog.csdn.net/qq_41975735/article/details/103822174)

**注：**

```
ODL使用锂版本，Carbon版本下发流表接收异常

下载指令：wget https://nexus.opendaylight.org/content/repositories/public/org/opendaylight/integration/distribution-karaf/0.3.4-Lithium-SR4/distribution-karaf-0.3.4-Lithium-SR4.tar.gz
解压指令：tar-zxvf distribution-karaf-0.3.4-Lithium-SR4.tar.gz
```

```
第三步安装feature过程中遇到问题，参考以下连接解决问题，若无遇到问题则忽略

[(13条消息) odl安装的一些坑_z的博客-CSDN博客](https://blog.csdn.net/zengxiaosen/article/details/72864594)
```



### mininet环境搭建

环境搭建参考以下链接，按步骤基本顺利执行

[(13条消息) Ubuntu安装Mininet教程_AlwaySimple的博客-CSDN博客_mininet安装](https://blog.csdn.net/qq_34039018/article/details/90031480)

使用安装指令: sudo ./install.sh -a ，出现下述问题

![1637548220284](README.assets/1637548220284.png)

换个安装方式: sudo apt-get install mininet  出现同样问题

![1637548573887](README.assets/1637548573887.png)

输入mn --version，显示版本编号为2.3.0，说明mininet已经安装完成，可能是当前端口地址被占用

```
重启虚拟机，再次更新软件即可：

sudo apt-get update 

sudo apt-get upgrade

```



### 测试mininet连接Opedaylight

参照以下连接第五步实行

[(13条消息) OpenDayLight安装_馋鱼夜炖桃的博客-CSDN博客_opendaylight安装](https://blog.csdn.net/qq_41975735/article/details/103822174)

**注：**opendaylight要在虚拟环境下启动才能在网页端打开，此时虚拟机需要开启两个终端分别启动opendaylight和mininet。

例程跑通状态如下

![1637566724706](README.assets/1637566724706.png)

![1637566685462](README.assets/1637566685462.png)



## 三层交换机实验

本实验开启三个终端，分别用于开启opendaylight、运行mininet和查看流表

![1637714560617](README.assets/1637714560617.png)



### 更改host地址

查看OpenDaylight所在虚拟机的IP为192.168.9.99（这是我的ip，在虚拟机中键入：ifconfig查看）

在下载文件夹里进入distribution-karaf-0.6.2-Carbon目录, 修改etc/org.apache.karaf.management.cfg文件的以下两行内容：

![1637652950894](README.assets/1637652950894.png)



本次实验网络有两种方式搭建网络拓扑：miniedit搭建和代码生成

### miniedit搭建网络拓扑

miniedit搭建网络拓扑如下

![1637714977830](README.assets/1637714977830.png)

mininet指令状态下执行pingall，在ODL中显示拓扑结构

![1637660006232](README.assets/1637660006232.png)



### 代码生成网络拓扑

进 入 mininet/mininet 文 件 夹 ， 使 用 sudo vim topo-4sw_4host.py 指令创建 topo-4sw_4host.py 的 python 脚本文件，脚本内编辑网络拓扑结构创建代码并保存，代码如下:

网络拓扑结构代码

- ```python
  from mininet.topo import Topo
  from mininet.cli import CLI
  from mininet.net import Mininet
  from mininet.log import setLogLevel
  from mininet.node import RemoteController
  from mininet.util import dumpNodeConnections
  host_name = locals()
  switch_name = locals()
  class MyTopo(Topo):
  	def build(self):
  		for i in range(4) :
  			host_name['host%s'%(i+1)] = self.addHost ('h%s'%(i+1))
  			if i<3:
  				switch_name['switch%s'%(i+1)] = self.addSwitch('s%s'%(i+1))
  self.addLink(host1, switch1, 1,1)
  self.addLink(host2, switch1, 1,2)
  self.addLink(switch1, switch2, 3,3)
  self.addLink(switch1, switch3, 4,3)
  self.addLink(host3, switch4, 1,1)
  self.addLink(host4, switch4, 1,2)
  self.addLink(switch4, switch2, 3,2)
  self.addLink(switch4, switch3, 4,2)
  def Test():
  	topo = MyTopo()
  	net = Mininet (topo = topo, controller = lambda name:RemoteController(name,ip='ControlLerIP'))
      net.start()
  	dumpNodeConnections(net.hosts)
  	CLI(net)
  	net.stop()
  TOPOS = {'mytopo':(lambda : MyTopo())}
  if__name__ == '__main__':
  	setLogLevel('info')
  	Test()
  ```

  ​

```
脚本编译指令：
sudo mn --custom topo-4sw_4host.py --topo mytopo --controller=remote,ip=192.168.9.99,port=6633 --switch ovsk, protocols=OpenFlow10
注：编译环境为python3
```



### 下发流表

下发流表过程可参考以下网站

[(13条消息) 使用OpenDaylight界面下发流表_令狐_JackieHao的博客-CSDN博客_opendaylight下发流表](https://blog.csdn.net/weixin_43891901/article/details/116008140)

















