# Easylogging++使用方法学习

本文介绍使用easylogging++记录Linux程序运行日志的入门使用方法

[日志库EasyLogging++学习系列（1）—— 简要介绍_撒门摩尔的博客-CSDN博客](https://blog.csdn.net/samenmoer/article/details/112424520?utm_medium=distribute.pc_relevant.none-task-blog-2%7Edefault%7EOPENSEARCH%7Edefault-5.control&depth_1-utm_source=distribute.pc_relevant.none-task-blog-2%7Edefault%7EOPENSEARCH%7Edefault-5.control)





### **克隆Easylogging++**

下载地址：https://github.com/amrayn/easyloggingpp

（如果需要下载其他版本的Easylogging++，请[点击此处](https://www.cppku.com/?golink=aHR0cHM6Ly9naXRodWIuY29tL2Vhc3lsb2dnaW5nL2Vhc3lsb2dnaW5ncHAvcmVsZWFzZXM=)）



在自定目录下使用指令克隆easyloggingpp文件：

```
git clone https://github.com/amrayn/easyloggingpp
```

easyloggingpp-9.97.0文件主要用于提供生成log所需的头文件和源文件：

```
easylogging++.h

easylogging++.cc
```





### 例程演示

使用指令克隆演示例程：

```
git clone 
```

注：例程中已包含完整的easyloggingpp文件，按照demo1、demo2…步骤依次演示。



#### demo1例程对照

demo1为基于C++的HELLO例程，用于往后学习的对照：

```
./build_project.sh    //编译例程，终端输出“Hello, world!”
```



#### demo2生成log文件

demo2在此前基础上加入了easyloggingpp中.h头文件（inc文件夹下）和.cc源文件，main.cpp代码如下：

```
#include "inc/easylogging++.h"

#include <iostream>

using namespace std;

INITIALIZE_EASYLOGGINGPP            //使用宏 INITIALIZE_EASYLOGGINGPP 初始化，必须有且只能调用一次
                                    //最好放置地方是程序入口函数顶部，紧跟在包含头文件后面。
int main()

{

LOG(INFO)    << "***** info log  *****";

cout << "Hello, world!" << endl;

        return 0;

}
```

demo2演示了easyloggingpp最基础的步骤，生成log文件：

```
./build_project.sh    //编译例程，终端输出“Hello, world!”
```

此时在/Build/bin文件夹下新增myeasylog.log文件，该文件记录当前运行记录。



#### demo3配置日志

main.cc代码如下：

```
#include "inc/easylogging++.h"

#include <iostream>

using namespace std;

INITIALIZE_EASYLOGGINGPP

void easylogginginit()

{

    el::Configurations conf( "../../log.conf" );        // 加载配置文件，构造一个配置器对象

    el::Loggers::reconfigureLogger( "default", conf );  // 用配置文件配置单一日志记录器

    el::Loggers::reconfigureAllLoggers( conf );         // 用配置文件配置所有的日志记录器

}

int main()

{

    easylogginginit();  //函数导入与配置


    LOG(TRACE)   << "***** trace log  *****";

    LOG(DEBUG)   << "***** debug log  *****";

    LOG(ERROR)   << "***** error log  *****";

    LOG(WARNING) << "***** warning log  *****";

    LOG(INFO)    << "***** info log  *****";

    // LOG(FATAL)   << "***** fatal log  *****";//这个会导致程序退出运行

    LOG(INFO)    << "***** info log123  *****";

    system("ls");

    return 0;

}      
```

log.conf配置:

```conf
* GLOBAL:
    FORMAT                  =   "%datetime:[%level]     %msg"
    ENABLED                 =   true
    TO_FILE                 =   true
    TO_STANDARD_OUTPUT      =   false  
    PERFORMANCE_TRACKING    =   false    
    FILENAME                =   "log/log_%datetime{%Y%M%d}.log"
    MAX_LOG_FILE_SIZE       =   209715200 ## Throw log files away after 2097152 2MB / 209715200 200MB / 4398046511104 1GB 
* INFO:
	FORMAT                  =   "%datetime:[%level]    %msg"
    FILENAME                =   "log/debug_%datetime{%Y%M%d%H}.log"
* DEBUG:
    FILENAME                =   "log/debug_log_%datetime{%Y%M%d}.log"
* WARNING:
	FORMAT                  =   "%datetime:[%level]   %msg"
    FILENAME                =   "log/warn_%datetime{%Y%M%d%H}.log"
* TRACE:
    FILENAME                =   "log/trace_log_%datetime{%Y%M%d}.log"
* VERBOSE:
    FORMAT                  =   "%datetime{%d/%M/%y} | %level-%vlevel | %msg"
* ERROR:
    FILENAME                =   "log/error_%datetime{%Y%M%d%H}.log"
#出现这个log会在终端上输出打印出来
    TO_STANDARD_OUTPUT      =   true
* FATAL:
    FILENAME                =   "log/fatal_%datetime{%Y%M%d%H}.log"
    TO_STANDARD_OUTPUT      =   true
```

编译demo3，相比于demo2，在/Build/bin文件夹下新增log文件夹以及相关log文件，如下所示：

![1630640350703](assets/1630640350703.png)

配置功能具体介绍：[日志库EasyLogging++学习系列（3）—— 配置功能_撒门摩尔的博客-CSDN博客](https://blog.csdn.net/samenmoer/article/details/112424643?utm_medium=distribute.pc_relevant.none-task-blog-2~default~baidujs_title~default-8.control&spm=1001.2101.3001.4242)



#### demo4循环例程演示

main.cc代码如下：

```
#include "easylogging++.h"
#include <iostream>

using namespace std;

INITIALIZE_EASYLOGGINGPP

int main()
{

    el::Configurations conf("../../log.conf");
    el::Loggers::reconfigureLogger("default", conf);
    el::Loggers::reconfigureAllLoggers(conf);

    LOG(INFO) << "my easyloging is launching";

    long m_ISum =0;

    for (int i = 0; i < 500000000; i++)
    {
        m_ISum = m_ISum + i;
    }

    
    cout << " Sum is :" << m_ISum << endl;
    for (int i = 0; i < 20; i++)
    {
        LOG(INFO) << " Index is :" << i;
    }    

    LOG(INFO) << " Sum is :" << m_ISum;
    LOG(INFO) << "my easyloging is success";

    return 0;
}
```

log.conf配置:

* ```
   * GLOBAL:
     FORMAT               =  "%datetime %level [%logger] %msg"
     FILENAME             =  "logs/Log-%datetime{%Y-%M-%d-%H-%m-%s}.log"
     ENABLED              =  true
     TO_FILE              =  true
     TO_STANDARD_OUTPUT   =  true
     SUBSECOND_PRECISION  =  6
     PERFORMANCE_TRACKING =  true
     MAX_LOG_FILE_SIZE    =  2097152 ## 2MB - Comment starts with two hashes (##)
     LOG_FLUSH_THRESHOLD  =  100 ## Flush after every 100 logs
   * DEBUG:
     FORMAT               = "%datetime{%d/%M} %func %msg"
   ```

编译demo4，编译结果如下：

![1630640430759](assets/1630640430759.png)

同/Build/bin/logs文件夹下生成**程序此次运行日志**:

![1630640511582](assets/1630640511582.png)

![1630640559472](assets/1630640559472.png)