## QT工程如何调用easylogging++

### 简介

​	easylogging++是一款轻量化的日志工具，用于记录程序执行日志，它具有编译速度快、可配置度高、扩展性强的特点。通过查看和分析日志信息，不仅可以有效地帮助我们调试程序，而且当程序正式发布运行之后，更是可以帮助我们快速、准确地定位问题。

​	在Visual Studio中运行甚至只需要添加头文件 include "easylogging++.h" 就能快速使用easylogging。在QT项目中调用easylogging++需要引入easylogging++.h、easylogging++.cpp、my_easylogging.cpp（自定义日志文件）等文件。

gitlab链接：

[Zeng Rixuan / easylogging · GitLab (linkortech.com)](http://git.linkortech.com:10020/Zengrixuan/easylogging)

### 文件、目录介绍

介绍一下文件和目录的结构有助于理解项目搭建

目录树状图和文件介绍如下

```
.
├──main.cpp						   主程序
├──feature						   存放特征库的文件夹（xdevice中包括easylogging、lua等）

	├── easyloggingpp			    存放easylogging库的文件夹

			├── inc				   存放easylogging官方头文件easylogging++.h

			├── src				   存放easylogging官方源文件easylogging++.cc

			├── my_easylogging.cpp	自定义日志源文件

			├── my_easylogging.h	自定义日志头文件

			├── normal_typedef.h	定义项目中数据格式的头文件

├──log							   存放log配置文件和日志的文件夹

	├── log.conf					log配置文件
```



### 路径更改

在搭建项目之前，先进行代码的相关路径更改

#### 配置文件.conf文件中的相关路径

```
* GLOBAL:
    FORMAT                  =   "%datetime:[%level]%msg"
    ENABLED                 =   true
    TO_FILE                 =   true
    TO_STANDARD_OUTPUT      =   false  
    PERFORMANCE_TRACKING    =   false
    MAX_LOG_FILE_SIZE       =   209715200 
    FILENAME                =   "./log/info_%datetime{%Y%M%d}.log"

* INFO:
    FORMAT                  =   "%datetime %msg"
    ENABLED                 =   true
    FILENAME                =   "./log/info_%datetime{%Y%M%d%H}.log"
* DEBUG:
    FORMAT                  =   "%datetime:[%level] %func[%line] %msg"
    ENABLED                 =   true
    FILENAME                =   "./log/debug_%datetime{%Y%M%d}.log"
* ERROR:
    FORMAT                  =   "%datetime:[%level] %func[%line] %msg"
    ENABLED                 =   true
    FILENAME                =   "./log/error_%datetime{%Y%M%d%H}.log"
    TO_STANDARD_OUTPUT      =   true
/*
    1.可以看到每个log等级都会输出一个.log文件，具体信息在FILENAME中设置，需要定位到自己本地的log文件夹位置，生成对应的例如info+时间.log、debug+时间.log文件。
%datetime{%Y%M%d%H}意思是获取当前时间,精确到小时
    2.如果各级都没有配置FILENAME，会找不到输出位置，默认输出在编译文件夹中,命名为:myeasylog.log
    3.如果除了GLOBAL配置了FILENAME，其他级别都没配置，则所有日志内容会打印在GLOBAL配置的日志中
    4.在对于log等级配置中添加：TO_STANDARD_OUTPUT = true，对应等级的log就会在终端打印，下面的ERROR例子在终端打印便是如此。
*/
```

#### my_easylogging.cpp中的相关路径

```
//读取配置文件：根目录下log文件夹中的log.conf   将路径更改为自己的conf文件路径
const string log_conf_file = R"(./log/log.conf)";

//const string log_conf_file 读取log.conf，根据log.conf中设置的路径生成log
```

### 搭建过程

1.在	QT文件栏新建QT Console Application项目，会在所选路径生成以项目命名的文件夹

2.进入生成的项目文件夹，根据树状图新建文件夹并放入文件

3.返回QT页面，在项目名处右击，添加现有文件，将文件夹中的头文件和源文件都添加进去

![1651057699366](README.assets/1651057699366.png)

添加之后效果如图所示：

![1651057749031](README.assets/1651057749031.png)

此时logtest.pro文件中自动生成头文件和源文件的路径：

```
SOURCES += main.cpp \
    $$PWD/feature/easyloggingpp/my_easylogging.cpp \
    $$PWD/feature/easyloggingpp/src/easylogging++.cc
    
HEADERS += \
    $$PWD/feature/easyloggingpp/my_easylogging.h \
    $$PWD/feature/easyloggingpp/inc/easylogging++.h \
    $$PWD/feature/easyloggingpp/inc/normal_typedef.h
```

4.在logtest.pro最后一行加入代码，含义是头文件所在路径，否则编译时会识别不到头文件

```
INCLUDEPATH += $$PWD/feature/easyloggingpp/inc
INCLUDEPATH += $$PWD/feature/easyloggingpp
```

5.将下述main.cpp代码拷入，启动编译即可

```
注：编译前先如下操作：
	QT左边状态栏——项目——build——shadow build 取消勾选
	否则会生成编译文件夹，此时log会认准编译文件所在目录，将log文件放在这里，而不是我们指定的路径
```

### info效果展示

log（info）的效果通过 my_easylogging.cpp 中的 log_test( ) 函数展示

```
	LOG(INFO) << "》》》》》》》》》》打印测试《《《《《《《《";
    LOG(INFO) << " UINT8 cc[] = {0X31, 0X31, 0X31};";

    LOG(INFO) << "     char buf[3] = {5, 6, 7};";
    LOG(INFO) << "#################封装之前###########";
    LOG(INFO) << "打印cc ：" << cc;
    LOG(INFO) << "打印buf[3]："
              << "buf = " << buf << " buf[0] = " << buf[0] << " buf[1] = " << buf[1] << " 		
    (INT8)buf[2] = " << (UINT8)(buf[2]);
    LOG(INFO) << "####################封装之后##########";
    LogInfoDump("打印cc", cc, 3);
    LogInfoDump("打印buf[3]", buf, 3);
```

此时终端输出为如下所示，info级别的不会将内容输出在终端上：

![1651732170563](README.assets/1651732170563.png)

此时各个级别log文件已经生成，进入log文件夹：

![1651738480171](README.assets/1651738480171.png)

由于测试的时info等级，只有info.log中有内容，打开可以看到代码运行内容：

![1651738691006](README.assets/1651738691006.png)

### error效果展示

同样的代码，将INFO等级改为ERROR进行测试，如下所示：

```
	LOG(ERROR) << "》》》》》》》》》》打印测试《《《《《《《《";
    LOG(ERROR) << "》》》》》》》》》》打印测试《《《《《《《《";
    LOG(ERROR) << " UINT8 cc[] = {0X31, 0X31, 0X31};";

    LOG(ERROR)  << "     char buf[3] = {5, 6, 7};";
    LOG(ERROR) << "#################封装之前###########";
    LOG(ERROR) << "打印cc ：" << cc;
    LOG(ERROR) << "打印buf[3]："
              << "buf = " << buf << " buf[0] = " << buf[0] << " buf[1] = " << buf[1] << " 		(INT8)buf[2] = " << (UINT8)(buf[2]);
    LOG(ERROR) << "####################封装之后##########";
    LogErrorDump("打印cc", cc, 3);
    LogErrorDump("打印buf[3]", buf, 3);
```

调试后，终端上会打印出error的信息，会打印出错误的内容，包括是哪个函数的第几行，如下所示：

![1651741728966](README.assets/1651741728966.png)

打开log文件夹中的error.log文件，日志内容与终端打印的error内容一致，如下所示：

![1651742341594](README.assets/1651742341594.png)



### 部分代码说明

在搭建项目之前，先进行代码说明以及路径配置，方便在项目中直接拷贝和配置

#### main.cpp

```c++
int main()
{
    easylogginginit(1,1); //自定义日志初始化函数，在my_easylogging.cpp中定义
    log_test();        	  //自定义日志自测函数，my_easylogging.cpp里面可以看细节的用法

    printf("Hello world\n\r");

    try					// try/catch异常处理
    {					//当程序的某部分检测到一个它无法处理的问题时，需要用到异常处理
        throw 20;
    }
    catch (int e)		 //捕获异常后进行日志记录
    {
        std::cout << "An exception occurred. Exception Nr. " << e << '\n'; //打印异常e
    }
    return 0;
}
```

#### my_easylogging.cpp部分代码

```c++
//log初始化配置，main（）中调用，最先配置
void easylogginginit(int enable_log ,int enable_terminal)
{

//必须设置标记 LoggingFlag::StrictLogFileSizeCheck 否则,配置文件中MAX_LOG_FILE_SIZE = 1048576不生效
    el::Loggers::addFlag(el::LoggingFlag::StrictLogFileSizeCheck);
	//读取配置文件：根目录下log文件加中的log.conf
    const string log_conf_file = R"(./log/log.conf)";
    // 加载配置文件，构造一个配置器对象
    el::Configurations conf(log_conf_file.data());

    // 用配置文件配置所有的日志记录器
    el::Loggers::reconfigureAllLoggers(conf);
#if ELPP_FEATURE_CRASH_LOG
    el::Helpers::setCrashHandler(myCrashHandler); //配置程序闪退的时候，再log中记录一下
#endif
    /// 注册回调函数
    el::Helpers::installPreRollOutCallback(rolloutHandler);

}


//log测试函数，main（）中调用
void log_test()
{
    char aa = 4;
    // char *cc = "12345";
    UINT8 cc[] = {0X31, 0X31, 0X31};
    char buf[3] = {5, 6, 7};
    LOG(INFO) << "》》》》》》》》》》打印测试《《《《《《《《";
    LOG(INFO) << " UINT8 cc[] = {0X31, 0X31, 0X31};";

    LOG(INFO) << "     char buf[3] = {5, 6, 7};";
    LOG(INFO) << "#################封装之前###########";
    LOG(INFO) << "打印cc ：" << cc;
    LOG(INFO) << "打印buf[3]："
              << "buf = " << buf << " buf[0] = " << buf[0] << " buf[1] = " << buf[1] << " (INT8)buf[2] = " << (UINT8)(buf[2]);
    LOG(INFO) << "####################封装之后##########";
//LogInfoDump是自己对log输出的封装，而不直接使用Easylogging给出的宏
    LogInfoDump("打印cc", cc, 3); 
    LogInfoDump("打印buf[3]", buf, 3);
}

//根据log的等级输出，logDump()中调用
void logStrOut(int size, std::string str, LEVEL_LOG logLevel)
{
    switch (logLevel)
    {
    case MY_ERR:
        // LOG(ERROR) << "[Arr Count:" << size << "]" << str;
        LOG(ERROR) << str;
        break;
    case MY_Debug:
        // LOG(DEBUG) << "[Arr Count:" << size << "]" << str;
        LOG(DEBUG) << str;
        break;
    case MY_Info:
        // LOG(INFO) << "[Arr Count:" << size << "]" << str;
        LOG(INFO) << str;
        break;
    case MY_Trace:
        // LOG(TRACE) << "[Arr Count:" << size << "]" << str;
        LOG(TRACE) << str;
        break;
    case MY_Warn:
        // LOG(WARNING) << "[Arr Count:" << size << "]" << str;
        LOG(WARNING) << str;
        break;
    default:
        break;
    }
}
```



### 附录

#### Level级别介绍

In order to start configuring your logging library, you must understand severity levels. Easylogging++ deliberately does not use hierarchical logging in order to fully control what's enabled and what's not. That being said, there is still option to use hierarchical logging using `LoggingFlag::HierarchicalLogging`. Easylogging++ has following levels (ordered for hierarchical levels)

| Level   | Description                                                  |
| ------- | ------------------------------------------------------------ |
| Global  | Generic level that represents all levels. Useful when setting global configuration for all levels. <br />代表所有级别的通用级别。在为所有级别设置全局配置时很有用。 |
| Trace   | Information that can be useful to back-trace certain events - mostly useful than debug logs.<br />可用于回溯某些事件的信息-大多数信息比调试日志有用。 |
| Debug   | Informational events most useful for developers to debug application. Only applicable if NDEBUG is not defined (for non-VC++) or _DEBUG is defined (for VC++).<br />信息事件对开发人员调试应用程序最有用。仅在未定义NDEBUG（对于非VC ++）或_DEBUG（对于VC ++）时适用。 |
| Fatal   | Very severe error event that will presumably lead the application to abort.<br />非常严重的错误事件，可能会导致应用程序中止。 |
| Error   | Error information but will continue application to keep running.<br />错误信息，但将继续使应用程序继续运行。 |
| Warning | Information representing errors in application but application will keep running.<br />表示应用程序错误的信息，但应用程序将继续运行。 |
| Info    | Mainly useful to represent current progress of application.<br />主要用于表示当前的应用进度。 |
| Verbose | Information that can be highly useful and vary with verbose logging level. Verbose logging is not applicable to hierarchical logging.<br />信息非常有用，并且随着详细的日志记录级别而变化。详细日志记录不适用于分层日志记录。 |
| Unknown | Only applicable to hierarchical logging and is used to turn off logging completely.<br />仅适用于分层日志记录，用于完全关闭日志记录。 |

#### qt终端打印log时中文乱码问题

测试发现是调用my_easylogging.cpp里面的函数输出乱码，猜测是my_easylogging.cpp的编码方式有误。

[Qt中输出中文出现乱码（win10系统下）_小菜鸡的蜕变之路的博客-CSDN博客_qt打印中文乱码](https://blog.csdn.net/qq_26079093/article/details/106101331)

此时，执行生成的log日志文件，在查看时编码方式也应该改为GBK。

**但需要注意的是，最好将编码方式都统一成utl-8，并且在代码中避免出现中文字符**



#### 对于多线程的保护

为避免多线程进行时，多线程同时抢占easylogging，要配置线程保护机制，否则容易崩盘。

```
添加代码为：
DEFINES += \
    ELPP_FEATURE_ALL \
    ELPP_FEATURE_CRASH_LOG \
    ELPP_THREAD_SAFE \
    ELPP_OS_UNIX \
```

1.cmake项目中，在camkelists的add_definitions中添加全局定义

2.qt项目中，在.pro文件中添加全局定义



#### con.fig代码

建议统一使用下述con.fig代码，更改修改路径就能使用，效果是将各个等级的log均打印在一个info_log文件中。

```
* GLOBAL:
    FORMAT                  =   "%datetime:[%level]%msg"
    ENABLED                 =   true
    TO_FILE                 =   true
    TO_STANDARD_OUTPUT      =   false  
    PERFORMANCE_TRACKING    =   false
    MAX_LOG_FILE_SIZE       =   209715200 
    FILENAME                =   "./xprotocol/protocfg/log/info_%datetime{%Y%M%d}.log"

* INFO:
    FORMAT                  =   "%datetime %msg"
    ENABLED                 =   true

* DEBUG:
    FORMAT                  =   "%datetime:[%level] %func[%line] %msg"
    ENABLED                 =   true

* WARNING:
    ENABLED                 =   true

* TRACE:
    ENABLED                 =   false

* VERBOSE:
    FORMAT                  =   "%datetime{%d/%M/%y} | %level-%vlevel | %msg"
    ENABLED                 =   true

* ERROR:
    FORMAT                  =   "%datetime:[%level] %func[%line] %msg"
    ENABLED                 =   true

    TO_STANDARD_OUTPUT      =   true
* FATAL:
    ENABLED                 =   true
    TO_STANDARD_OUTPUT      =   true
```

