/**
 * @file main.cpp
 * @brief 
 * @zengrx {zengrx} ({757876947@qq.com})
 * @version 1.0
 * @date 2021-10-25
 * 
 * @copyright Copyright (c) 2021  linkor
 * 
 * @par 修改日志:
 * <table>
 * <tr><th>Date       <th>Version <th>Author  <th>Description
 * <tr><td>2021-10-25 <td>1.0     <td>zengrx     <td>内容
 * </table>
 */

#include <stdio.h>
#include <WinSock2.h>

#define version_h 2
#define version_l 2
#define DEFAULT_BUFLEN 512
int main()
{
    
    /**
     * @brief 1.初始化套接字库
     */

    ///高位字节指定次要版本号；低位字节指定主版本号。
    WORD wVersionRequested = MAKEWORD(version_h, version_l);
    WSADATA wsaData;

    int error = WSAStartup(wVersionRequested, &wsaData);

    if (errno != 0)
    {
        printf("Cant initiates use of the Winsock DLL by a process!\n");
        return 1;
    }

    ///确认WinSock DLL支持2.2,如果DLL支持更高版本,它依然返回2.2
    if (LOBYTE(wsaData.wVersion) != version_l ||
        HIBYTE(wsaData.wVersion) != version_h)
    {
        /* 找不到可用的WinSock DLL */
        printf("could not find a usable WinSock DLL!\n");
        WSACleanup();
        return 1;
    }

    /**
     * @brief 2.创建套接字
     */
    SOCKADDR_IN server_address;

    ///address.sin_family 用于传输地址，他的成员始终设置为 AF_INET.
    server_address.sin_family = AF_INET;
    ///该语句用在服务器端，表示监听所有的客户端连接。INADDR_ANY:转换过来就是0.0.0.0，泛指本机的意思，也就是表示本机的所有IP
    server_address.sin_addr.S_un.S_addr = inet_addr("127.0.0.1");
    ///定义传输协议端口号
    server_address.sin_port = htons(5000);
    ///申请套接字
    SOCKET socket_server = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (INVALID_SOCKET == socket_server)
    {
        wprintf(L"socket function failed with error: %ld\n", WSAGetLastError());
        getchar();
        WSACleanup();
        return 1;
    }
    
    
    /**
     * @brief 3.绑定套接字到本地的某个地址和端口
     */
    if(SOCKET_ERROR==connect(socket_server, (SOCKADDR *)&server_address, sizeof(server_address)))
    {
        wprintf(L"connect function failed with error: %ld\n", WSAGetLastError());
        getchar();
        closesocket(socket_server);
        WSACleanup();
        return 1;
    }
    wprintf(L"Connected to server.\n");

    
    /**
     * @brief 4.进行会话
     */
    int recv_ret;
    int send_ret;
    char send_buff[DEFAULT_BUFLEN] ={0};
    char recv_buff[DEFAULT_BUFLEN] = {0};

    while (1)
    {
        printf("You send:");
        gets(send_buff);
        send_ret = send(socket_server, send_buff,DEFAULT_BUFLEN, 0);
        if (SOCKET_ERROR == send_ret)
        {
            wprintf(L"send failed with error: %d\n", WSAGetLastError());
            getchar();
            closesocket(socket_server);
            WSACleanup();
            return 1;
        }

        int ret = recv(socket_server, recv_buff, DEFAULT_BUFLEN, 0);
        if (ret > 0)
            printf("Receive from Server: %s\n", recv_buff);
        else
        {
            if (0 == ret)
            {
                printf("Connection closed\n");
                break;
            }
            else
            {
                printf("recv failed: %d\n", WSAGetLastError());
                getchar();
                closesocket(socket_server);
                WSACleanup();
                return 1;
            }
        }
    }

    
    /**
     * @brief 5.关闭套接字
     */
    if (SOCKET_ERROR == closesocket(socket_server))
    {
        wprintf(L"closesocket function failed with error %d\n", WSAGetLastError());
        getchar();
        WSACleanup();
        return 1;
    }

    WSACleanup();
    return 0;
}
