/**
 * @file main.cpp
 * @brief 
 * @zengrx {zengrx} ({757876947@qq.com})
 * @version 1.0
 * @date 2021-10-25
 * 
 * @copyright Copyright (c) 2021  linkor
 * 
 * @par 修改日志:
 * <table>
 * <tr><th>Date       <th>Version <th>Author  <th>Description
 * <tr><td>2021-10-25 <td>1.0     <td>zengrx     <td>TCP_server注释
 * </table>
 */

#include <stdio.h>
#include <WinSock2.h>

#define version_h 2
#define version_l 2
#define DEFAULT_BUFLEN 512


int main()
{
    
    /**
     * @brief 1.初始化套接字库
     */

    ///高位字节指定次要版本号；低位字节指定主版本号。
    WORD wVersionRequested = MAKEWORD(version_h, version_l);
    WSADATA wsaData;

    int error = WSAStartup(wVersionRequested, &wsaData);

    if (errno != 0)
    {
        printf("Cant initiates use of the Winsock DLL by a process!\n");
        return 1;
    }

    ///确认WinSock DLL支持2.2,如果DLL支持更高版本,它依然返回2.2
    if (LOBYTE(wsaData.wVersion) != version_l ||
        HIBYTE(wsaData.wVersion) != version_h)
    {
        ///找不到可用的WinSock DLL 
        printf("could not find a usable WinSock DLL!\n");
        WSACleanup();
        return 1;
    }

    
    /**
     * @brief 2.创建套接字
     */
    SOCKADDR_IN server_address;

    ///address.sin_family 用于传输地址，他的成员始终设置为 AF_INET.
    server_address.sin_family = AF_INET;
   
    ///该语句用在服务器端，表示监听所有的客户端连接。INADDR_ANY:转换过来就是0.0.0.0，泛指本机的意思，也就是表示本机的所有IP
    server_address.sin_addr.S_un.S_addr = htonl(INADDR_ANY);
    ///定义传输协议端口号
    server_address.sin_port = htons(5000);
    ///申请套接字
    SOCKET socket_server = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (INVALID_SOCKET == socket_server)
    {
        wprintf(L"socket function failed with error: %ld\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }

   
    /**
     * @brief 3.绑定套接字到本地的某个地址和端口
     */
    if (SOCKET_ERROR == bind(socket_server, (SOCKADDR *)&server_address, sizeof(server_address)))
    {
        wprintf(L"bind failed with error %u\n", WSAGetLastError());
        closesocket(socket_server);
        WSACleanup();
        return 1;
    }

    wprintf(L"bind returned success\n");

    
    /**
     * @brief 4.监听客户端
     */
    if (SOCKET_ERROR == listen(socket_server, 1))
        wprintf(L"listen function failed with error: %d\n", WSAGetLastError());

    wprintf(L"Listening on socket...\n");

    
    /**
     * @brief 5.接受客户端连接
     */
    SOCKADDR_IN client_address;
    int address_length=sizeof(client_address);
    SOCKET socket_client = accept(socket_server, (SOCKADDR *)&client_address, &address_length);
    if (INVALID_SOCKET == socket_client)
        wprintf(L"accept failed with error: %ld\n", WSAGetLastError());
    wprintf(L"connect client success\n");
    
    /**
     * @brief 6.进行会话
     */
    char send_buff[DEFAULT_BUFLEN] = "I receive your message!";
    char recv_buff[DEFAULT_BUFLEN] = {0};

    while (1)
    {
        int ret = recv(socket_client, recv_buff, DEFAULT_BUFLEN, 0);
        if (ret > 0)
            printf("Receive from Client: %s\n", recv_buff);
        else
        {
            if (0 == ret)
            {
                printf("Connection closed\n");
                break;
            }
            else
            {
                printf("recv failed: %d\n", WSAGetLastError());
                closesocket(socket_client);
                closesocket(socket_server);
                WSACleanup();
                return 1;
            }
        }
        ret = send(socket_client, send_buff,DEFAULT_BUFLEN, 0);
        if (SOCKET_ERROR == ret)
        {
            wprintf(L"send failed with error: %d\n", WSAGetLastError());
            closesocket(socket_client);
            closesocket(socket_server);
            WSACleanup();
            return 1;
        }
    }

    
    /**
     * @brief 7.关闭套接字
     */
    if (SOCKET_ERROR == closesocket(socket_client))
    {
        wprintf(L"closesocket function failed with error %d\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }
    if (SOCKET_ERROR == closesocket(socket_server))
    {
        wprintf(L"closesocket function failed with error %d\n", WSAGetLastError());
        WSACleanup();
        return 1;
    }

    WSACleanup();
    return 0;
}
