export function addRocketLaunch() {
  const script = document.createElement('script');
  script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
  script.onload = () => {
      window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

      var viewer = new Cesium.Viewer('cesiumContainer', {
        shouldAnimate: true  // 一开始就播放动画
      });    
  
      var czml =
        [
          {
            id: "document",
            name: "SpaceX",
            version: "1.0",
            clock: {
              interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
              currentTime: "2019-08-28T04:00:00.00Z",
              multiplier: 1,
              range: "LOOP_STOP",
              step: "SYSTEM_CLOCK_MULTIPLIER"
            }
          },     
          {
            id: "Vulcan",
            availability: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
            name: "Vulcan",
            path: {
              show: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                  boolean: true
                }
              ],
              width: 1,
              resolution: 86400,
              leadTime: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1053,
                    1053, 0
                  ]
                }
              ],
              trailTime: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    1053, 1053
                  ]
                }
              ],
              material: {
                solidColor: {
                  color: [
                    {
                      rgba: [ 0, 255, 0, 255 ]
                    }
                  ]
                }
              }
            },
            model: {
              show: true,
              gltf: [
                {
                  interval: "2019-08-28T04:00:00Z/9999-12-31T23:59:59.9999999Z",
                  uri: "https://cesium.com/public/SandcastleSampleData/launchvehicle.glb"
                }
              ],
              minimumPixelSize: 128,
              scale: 1,
              runAnimations: false,
              articulations: {   // 定义动画参数
                "BoosterFlames Size": {   // 二级发动机底部火焰样式的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    180, 1,
                    182, 0,
                    1000,0                  
                  ]
                },
                "Booster MoveZ": {  // 二级发动机随着z轴向下掉落的情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    180, 0,
                    200, -300,
                    1000,-300
                  ]
                },
                "Booster Yaw": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    190, 0,
                    200, 90,
                    1000, 90
                  ]
                },
                "Booster Size": {  // 二级发动机随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    200, 1,
                    201, 0,
                    1000,0
                  ]
                },
                "InterstageAdapter MoveZ": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    180, 0,
                    200, -300,
                    1000,-300
                  ]
                },
                "InterstageAdapter Size": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    190, 1,
                    191, 0, 
                    1000,0
                  ]
                },
  
                "SRBFlames Size": {   // 一级助推器底部火焰随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    60, 1,
                    61, 0, 
                    1000,0
                  ]
                },
                "SRBs Separate": {  // 一级助推器分开的距离
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    61, 0,
                    71, 40,
                    1000,40
                  ]
                },
                "SRBs Drop": {  // 一级助推器掉落：随时间的变化掉落的距离，负号表示向下掉落
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    61, 0,
                    71, -150,
                    1000,-150
                  ]
                },
                "SRBs Rotate": {  // 一级助推器掉落的张开角度随时间的变化，张开的角度单位为度
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    61, 0,
                    71, 120,
                    1000,120
                  ]
                },
                "SRBs Size": {  // 一级助推器的显示和消失情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,1,
                    70, 1,
                    71, 0, 
                    1000,0
                  ]
                },
                "UpperStageFlames Size": {   // 顶部卫星仓助推器底部火焰随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    181, 0,
                    182, 1,
                    1000,1,
                    1001,0,
                    1050,0
                  ]
                },
                "Fairing Open": {  // 整流罩随时间的变化而打开的角度
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    200, 0,
                    210, 120,  // 第210秒时，打开的角度为120度
                    1000,120
                  ]
                },
                "Fairing Separate": {  // 整流罩分离：随时间的变化分离出去的距离，负号表示往外部分离
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    200, 0,
                    210, -50,
                    1000,-50
                  ]
                },
                "Fairing Drop": {  // 整流罩掉落：随时间的变化掉落的距离，负号表示向下掉落
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    202, 0,
                    210, -150,
                    1000,-150
                  ]
                },
                "Fairing Size": {  // 整流罩的显示和消失：1表示显示，0表示消失
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    215, 1,
                    216, 0, 
                    1000,0
                  ]
                }
  
              }
            },
            position: {
              interpolationAlgorithm: "LAGRANGE",
              interpolationDegree: 5,
              referenceFrame: "FIXED",
              epoch: "2019-08-28T04:00:00Z",
              cartesian: [
                0.000, 917843.164, -5530578.249, 3031358.548,
                5.000, 917858.034, -5530668.136, 3031408.144,
                10.000, 917904.041, -5530947.370, 3031562.198,
                15.000, 917995.379, -5531429.784, 3031827.039,
                20.000, 918185.888, -5532123.853, 3032201.781,
                25.000, 918522.148, -5533037.209, 3032685.775,
                30.000, 919039.536, -5534178.813, 3033280.277,
                35.000, 919765.781, -5535552.193, 3033984.231,
                40.000, 920725.932, -5537159.564, 3034796.104,
                45.000, 921951.333, -5539013.869, 3035719.776,
                50.000, 923478.083, -5541133.458, 3036761.666,
                55.000, 925347.644, -5543541.795, 3037930.491,
                60.000, 927605.957, -5546265.685, 3039236.339,
                65.000, 930159.431, -5549170.295, 3040612.213,
                70.000, 932893.237, -5552105.857, 3041984.985,
                75.000, 935823.252, -5555076.264, 3043355.017,
                80.000, 938964.862, -5558083.710, 3044721.750,
                85.000, 942333.298, -5561129.288, 3046084.004,
                90.000, 945943.826, -5564213.327, 3047440.156,
                95.000, 949811.859, -5567335.599, 3048788.235,
                100.000, 953953.060, -5570495.476, 3050126.007,
                105.000, 958383.411, -5573692.036, 3051451.024,
                110.000, 963119.273, -5576924.135, 3052760.660,
                115.000, 968177.426, -5580190.468, 3054052.136,
                120.000, 973575.121, -5583489.609, 3055322.543,
                125.000, 979330.120, -5586820.054, 3056568.856,
                130.000, 985460.755, -5590180.254, 3057787.947,
                135.000, 991985.993, -5593568.654, 3058976.602,
                140.000, 998925.515, -5596983.723, 3060131.528,
                145.000, 1006299.806, -5600423.996, 3061249.362,
                150.000, 1014130.264, -5603888.099, 3062326.677,
                155.000, 1022439.320, -5607374.791, 3063359.991,
                160.000, 1031250.582, -5610882.993, 3064345.765,
                165.000, 1040588.998, -5614411.827, 3065280.405,
                170.000, 1050481.047, -5617960.649, 3066160.261,
                175.000, 1060954.957, -5621529.087, 3066981.622,
                180.000, 1072040.964, -5625117.088, 3067740.708,
                185.000, 1083771.619, -5628724.957, 3068433.661,
                190.000, 1096182.138, -5632353.415, 3069056.535,
                195.000, 1109310.838, -5636003.654, 3069605.272,
                200.000, 1123199.643, -5639677.407, 3070075.687,
                205.000, 1137894.713, -5643377.031, 3070463.435,
                210.000, 1153447.204, -5647105.606, 3070763.982,
                215.000, 1169914.223, -5650867.058, 3070972.558,
                220.000, 1187360.015, -5654666.310, 3071084.105,
                225.000, 1205857.496, -5658509.476, 3071093.203,
                230.000, 1225490.224, -5662404.112, 3070993.980,
                235.000, 1245704.746, -5666236.399, 3070784.103,
                240.000, 1265936.771, -5669896.839, 3070465.398
              ]
            },
            orientation: {  // 火箭的飞行方位
              "interpolationAlgorithm": "LINEAR",
              "interpolationDegree": 1,
              "epoch": "2019-08-28T04:00:00Z",
              "unitQuaternion":[
                  0,0.722984469848251,-0.640384836496241,0.1341966101407179,0.22179266753133725,
                  1,0.7229621157600349,-0.6404100730249704,0.13418886803435182,0.22179735174159645,
                  2,0.7229341719109916,-0.6404416175885533,0.13417919017146634,0.22180320662437597,
                  3,0.7229118158407721,-0.6404668523615189,0.13417144769722708,0.2218078902265571,
                  4,0.7228894588897065,-0.6404920863540949,0.1341637050595041,0.221812573558472,
                  5,0.7228671010578217,-0.640517319566251,0.13415596225830653,0.22181725662011503,
                  6,0.7228447423451456,-0.6405425519979558,0.1341482192936441,0.22182193941148037,
                  7,0.7228223827517051,-0.6405677836491793,0.13414047616552616,0.2218266219325625,
                  8,0.7227944320213707,-0.6405993221156093,0.1341307970255337,0.22183247470382064,
                  9,0.7227720704463099,-0.6406245520106364,0.1341230535296753,0.2218371566167444,
                  10,0.722749707990573,-0.640649781125082,0.134115309870392,0.22184183825936643,
                  11,0.7325985472067631,-0.6293624931834747,0.13064613932779767,0.22390579957464835,
                  12,0.7416083208967981,-0.6187227849782444,0.12738149256427075,0.2257723833366159,
                  13,0.7496089384666046,-0.6090034537366417,0.12441210328180824,0.2274266063256652,
                  14,0.7566950556907154,-0.6001769297758566,0.12172169094359413,0.22887567719590476,
                  15,0.7629658687060288,-0.5921842543557891,0.11928679534425676,0.2301554964349763,
                  16,0.7685412426700112,-0.5849307747978074,0.11708218395535598,0.23128361206517822,
                  17,0.7735197352842451,-0.5783323021042686,0.11508609564909775,0.23228034367293188,
                  18,0.7779989429811806,-0.5722934906574213,0.11325822014089924,0.23317457160210564,
                  19,0.7820447068562919,-0.5667494671191624,0.11158321266182447,0.2339878301328258,
                  20,0.7857428294641052,-0.5616113363579892,0.11002538769157115,0.23472393760171792,
                  21,0.7891461106505435,-0.5568181934274639,0.10857868487821491,0.2353987780414613,
                  22,0.79230456700711,-0.5523137313791615,0.107221861192316,0.23602221868323944,
                  23,0.7952586692171513,-0.5480523699650737,0.10593524499869424,0.23660087209834713,
                  24,0.7980471659162047,-0.5439859717925845,0.10471182383580174,0.23714007973130838,
                  25,0.8006912263339976,-0.5400869456277596,0.10353419711942355,0.2376558883366305,
                  26,0.8032153043618433,-0.5363249613045822,0.10239490490422824,0.23815120022835054,
                  27,0.8056403386998425,-0.5326743229140798,0.10130131555156709,0.23862052266129902,
                  28,0.807975722954782,-0.5291252497853631,0.10022815397318326,0.23907324883056746,
                  29,0.8102414398418379,-0.5256510650816937,0.09918308373340579,0.23950466142152355,
                  30,0.8124391030025412,-0.522247710031348,0.09815844253422763,0.23992697522099127,
                  31,0.8145856585347871,-0.518894751499507,0.09715266934739455,0.24033268736147384,
                  32,0.8166822362480016,-0.515587625585817,0.09615840083425449,0.24073447465774764,
                  33,0.8187361296400982,-0.5123191149208184,0.09518193163489921,0.24112377402270196,
                  34,0.8207414276273278,-0.5090979173480034,0.09421635596685385,0.24150796632100663,
                  35,0.8227253722022236,-0.5058880901501561,0.09325700026747816,0.2418746247129944,
                  36,0.8246729983428778,-0.5027063448842031,0.09229802469484022,0.24224337195218226,
                  37,0.8265911022394841,-0.4995447338529317,0.0913576381673436,0.24260253610958654,
                  38,0.8284866973678142,-0.4963963826904395,0.09041834619241051,0.24295050155998488,
                  39,0.8303492157699334,-0.49327653108604985,0.08948319541288496,0.24329241971066345,
                  40,0.832179034722444,-0.4901796314731287,0.08855736933761801,0.24363820593923669,
                  41,0.8339829649987511,-0.4871040396510243,0.08764172360965199,0.2439692540675458,
                  42,0.8357550056433899,-0.48405819693238505,0.08672961562788395,0.24429327927232303,
                  43,0.8375039768869902,-0.48102789348165864,0.08582510062339338,0.24460847592440157,
                  44,0.8392196226146338,-0.4780286978557113,0.08493131160125073,0.2449197038921454,
                  45,0.8409065297569724,-0.47505373707104714,0.08405021505667468,0.24522584785426924,
                  46,0.8425672254303463,-0.47210276693783637,0.0831740143109325,0.245522975347831,
                  47,0.8441917042243813,-0.4691915391380762,0.08230585737070253,0.24581580901653052,
                  48,0.8457926861516801,-0.46629839428605463,0.08145200522621647,0.24610182929673877,
                  49,0.8473604654979634,-0.46344514222922234,0.08059818108170497,0.24637933123850222,
                  50,0.848895274698886,-0.46062626680164803,0.07976167741060064,0.24665427169000578,
                  51,0.8504058170506538,-0.45783329402107603,0.07892913012113871,0.24691863767350847,
                  52,0.8518842109357959,-0.4550755392415173,0.0781135830573011,0.24717971778503386,
                  53,0.8533290685300448,-0.45236010377112756,0.07730502499229158,0.24743437600455231,
                  54,0.8547487289876081,-0.44967249849528756,0.07650759936307315,0.2476809270629727,
                  55,0.856137540465226,-0.44702138845545103,0.07572670897708635,0.24792308407450525,
                  56,0.8574941514984157,-0.4444138239434401,0.07495230522090124,0.24815778282386025,
                  57,0.8588245831812935,-0.4418358649026012,0.07418469103906461,0.2483908923948024,
                  58,0.8601237658344255,-0.4393024497904642,0.0734348588242122,0.24861171847757124,
                  59,0.8613975429637984,-0.43679935056279556,0.07269154573646026,0.24883034280870023,
                  60,0.8626425656913194,-0.4343346967287153,0.07196405145847498,0.24904286854426227,
                  61,0.8638613011316026,-0.43190791992292366,0.07124444884135524,0.2492457213762348,
                  62,0.8650794986226389,-0.4294594703659661,0.07051940397140763,0.24945748743885257,
                  63,0.866303358187329,-0.42698703347444417,0.06978864622289685,0.24965998817677165,
                  64,0.8675247615975736,-0.4244996712882718,0.0690540316653712,0.24986467898040404,
                  65,0.8687457663026229,-0.42199673384990505,0.0683192561762648,0.2500640505686554,
                  66,0.8699638913654857,-0.4194783242470369,0.06756911569143621,0.2502702095971403,
                  67,0.8711815373525268,-0.4169446886078629,0.06683025899740841,0.2504667085664667,
                  68,0.872396030060593,-0.41439544173754045,0.06607604899951863,0.25067018241162864,
                  69,0.8736096052661125,-0.41183041504637946,0.06532158618894394,0.25086860546364603,
                  70,0.8748185658528208,-0.40925721188757785,0.06456462793199086,0.25106258219261496,
                  71,0.8760242089450097,-0.40666874578276263,0.06380376107999494,0.25125922195571637,
                  72,0.8772250700011747,-0.4040720724929827,0.06304033358066966,0.25145149260781446,
                  73,0.8784210886202233,-0.4014671947586772,0.062274288675877684,0.2516394157714044,
                  74,0.8796102734695433,-0.3988552954353598,0.06151346645365964,0.25182595885821946,
                  75,0.8807976927413184,-0.3962268799812875,0.06074076591003073,0.2520123873910319,
                  76,0.8819746918961102,-0.3935991476535796,0.05997103865079627,0.2521979943304108,
                  77,0.8831500316475032,-0.39095554086977036,0.059200731122120674,0.25237880279224323,
                  78,0.8843145988039058,-0.38831197869763806,0.05842199466354925,0.2525635921540245,
                  79,0.885476171483691,-0.385659744177895,0.05764377388591624,0.2527364373955905,
                  80,0.8866284108050373,-0.38300113632352617,0.05686720164520158,0.25291562250139027,
                  81,0.8877701714256424,-0.38034344898901645,0.056093424068938344,0.253093878460636,
                  82,0.8889106854455648,-0.3776759049647196,0.055311991271769875,0.2532573547428149,
                  83,0.8900366682798302,-0.37501118681538037,0.05453789543774942,0.253430378687877,
                  84,0.8911591126362606,-0.3723371312274947,0.053752732071339196,0.25359641257221865,
                  85,0.8922692685449742,-0.36966556490059643,0.05297814927075059,0.25376413898891553,
                  86,0.8933780196087484,-0.36698424372022587,0.05219558503510628,0.2539171121525444,
                  87,0.894472302970718,-0.3643060268167945,0.0514202990088939,0.2540794578336802,
                  88,0.8955579549484225,-0.3616277717359422,0.05063949521931818,0.25423797033847884,
                  89,0.89663544104202,-0.358950504001712,0.04986425335784957,0.25438745602203633,
                  90,0.8977021123484203,-0.35627374913297,0.04908022965732064,0.2545408890938871,
                  91,0.8987615433534971,-0.353590713146195,0.04830076340466603,0.25469262262604286,
                  92,0.8998098059136085,-0.3509167430790577,0.04752443216298646,0.25483559593606003,
                  93,0.9008478307810204,-0.34824451734815576,0.04675030710787176,0.25497715721099373,
                  94,0.9018764506784298,-0.3455666504284122,0.04597755753340023,0.25512471857236496,
                  95,0.9028957906887609,-0.3428966380189702,0.045199697288776805,0.2552607963569955,
                  96,0.9039033270447723,-0.3402301153379016,0.04443195958504512,0.2553978170266591,
                  97,0.9049024600735787,-0.3375641304939749,0.04365820088028317,0.25553073602314236,
                  98,0.9058908583798211,-0.33490780693533095,0.042887118144635084,0.2556544712202119,
                  99,0.9068683419164637,-0.3322477455436038,0.04212533363993548,0.2557864388051111,
                  100,0.9078346418785762,-0.3295963472304626,0.041355148924495475,0.25591456104521787,
                  101,0.9087904619941011,-0.3269549160334838,0.04058743713568935,0.2560332771669387,
                  102,0.9097377525915081,-0.32430965299646103,0.039831813118742856,0.25615209768171043,
                  103,0.9106740753010302,-0.3216733075417496,0.039067590277857805,0.2562669217430257,
                  104,0.911596373388307,-0.3190492088401598,0.0383109070703518,0.25638238777888267,
                  105,0.9125134303405135,-0.3164182808446541,0.03754999717960008,0.25649309680245697,
                  106,0.9134138906212254,-0.3138077684489235,0.03679430915198913,0.2566046135503628,
                  107,0.9143034101990776,-0.31120187588648257,0.0360482898349353,0.25671616104766026,
                  108,0.9151873424423551,-0.30859704289214046,0.03529835872984509,0.25681514601460953,
                  109,0.916057787875607,-0.3060050133410735,0.03455573062517038,0.25691430976794527,
                  110,0.916914145044534,-0.3034245093575981,0.03380959312233814,0.25701931668894906,
                  111,0.917763640025592,-0.3008470218818875,0.03306746084703619,0.2571138143019639,
                  112,0.91860262175925,-0.29827465629294647,0.03233476135068248,0.2572079235147149,
                  113,0.9194289062834288,-0.2957200839971882,0.031590678140356085,0.25729777936427384,
                  114,0.920243461862262,-0.29317258378316324,0.030864096629780916,0.25738922774057843,
                  115,0.9210506686001947,-0.2906270021822681,0.03013052836226296,0.2574757517404181,
                  116,0.9218435464420244,-0.28810453461769564,0.029412418352446915,0.257556134973666,
                  117,0.922627015563736,-0.2855844169563812,0.028684691186390762,0.25763951450656547,
                  118,0.9234003598232189,-0.2830778302102515,0.027966386978537833,0.25771418028733467,
                  119,0.9241616869308645,-0.2805773242973706,0.02725475854417973,0.25779588754657323,
                  120,0.9249145073854895,-0.2780887703962283,0.026544261901604055,0.2578666166208227,
                  121,0.9256544362464492,-0.27561272451612506,0.025829973768607822,0.2579424416360753,
                  122,0.9263847696066004,-0.27315065246001813,0.025124866666444312,0.2580091486296283,
                  123,0.9271034128355119,-0.2707028999682034,0.02442647873066764,0.2580746965403071,
                  124,0.9278119021455776,-0.26825983313787966,0.023726489656714717,0.25814490088012987,
                  125,0.9285088742404723,-0.2658391672456582,0.023033250685171897,0.25820588098976316,
                  126,0.9291981578573112,-0.2634231499916274,0.02234066520905871,0.2582632807061138,
                  127,0.929876297542302,-0.26101391708978877,0.021654617778656876,0.25832708701049006,
                  128,0.9305433791302361,-0.25862741461851035,0.020975140738585224,0.25838135272426954,
                  129,0.9312008254948623,-0.2562539310543986,0.020293936892005288,0.2584320056461237,
                  130,0.9318474983419398,-0.25388749360010926,0.019619218611730594,0.25848881346856795,
                  131,0.9324858048223263,-0.2515359764086669,0.01895314640247241,0.25853559642425156,
                  132,0.9331125692515903,-0.24919788846313332,0.018283045856517233,0.2585866889931123,
                  133,0.9337312458608593,-0.2468749148396508,0.017621469843240714,0.25862757147413057,
                  134,0.9343374726809841,-0.2445674662293449,0.016964052465269025,0.2586744334684531,
                  135,0.9349369147003062,-0.24226536788223282,0.016306951724578966,0.25871710492545924,
                  136,0.9355243040275447,-0.23998696301584307,0.015653846027656862,0.25875759169684864,
                  137,0.9361039992177557,-0.23771602186388777,0.015009214127706297,0.2587955159754521,
                  138,0.9366740356336779,-0.23546079481818288,0.01437076116515705,0.25883092221920306,
                  139,0.9372356521587045,-0.2332193895471895,0.013730199628497114,0.2588619907982741,
                  140,0.937784544454644,-0.2309959660718423,0.013101974154723445,0.25890027059426063,
                  141,0.9383252856701971,-0.22878651445181078,0.012471598248816704,0.25893406171080396,
                  142,0.9388591925489469,-0.22659299933484836,0.011849262311076275,0.25895679987492176,
                  143,0.9393806693192897,-0.2244138049176913,0.011220734362423324,0.2589913075606513,
                  144,0.9398964921173822,-0.2222445154335665,0.010610691733438538,0.259016162982307,
                  145,0.9404046310883859,-0.2200894819694122,0.009998332121240405,0.2590362582897343,
                  146,0.9409019321926845,-0.21795087707032007,0.009389979012252789,0.25906137781325256,
                  147,0.9413907993170928,-0.21582868715747572,0.008787534530986685,0.2590832298661426,
                  148,0.941871375184718,-0.21372298977945925,0.00819096147868513,0.25910172596382364,
                  149,0.9423447624114695,-0.21163181300043377,0.007591943625647107,0.25911520000533667,
                  150,0.9428069065177058,-0.20955938286101433,0.0070051710552025,0.2591349641710135,
                  151,0.9432639285245086,-0.20749336808588764,0.0064181723402681745,0.259149513618482,
                  152,0.943710899022294,-0.20544416373367114,0.0058351356606878985,0.2591686436398656,
                  153,0.944152480174383,-0.20341173413576996,0.005259627694362834,0.25917580310082355,
                  154,0.9445842866407093,-0.20139624604082293,0.0046880436865566755,0.2591873834863878,
                  155,0.9450087171968187,-0.19939771713199322,0.004122139744330039,0.2591950670605076,
                  156,0.9454245200519481,-0.19741415919552938,0.0035518601100864855,0.2592055379875676,
                  157,0.9458340377555893,-0.19544151152296402,0.0029977783753093595,0.25921342928442226,
                  158,0.9462374009601806,-0.1934839079443982,0.0024410009175943603,0.2592157400799698,
                  159,0.946631607478503,-0.19154351556028135,0.0018881165833940644,0.25922213714349585,
                  160,0.9470182263725037,-0.18962247713126096,0.0013491001193955132,0.2592257221298645,
                  161,0.9473984293140862,-0.1877083862693711,0.0008079308785136493,0.25923179802070306,
                  162,0.9477704788876746,-0.18581992022548433,0.0002700231767802652,0.2592334925967451,
                  163,0.9481385557955077,-0.18393848043622957,-0.00026844611656427764,0.2592293238919982,
                  164,0.9484972959607669,-0.18207662056583904,-0.000794742161067924,0.25923030722377777,
                  165,0.9488498923812458,-0.18023228034192576,-0.0013155886979311362,0.2592266885897858,
                  166,0.9491965233062621,-0.17839508437467158,-0.0018386334035652293,0.2592253333327316,
                  167,0.94953646480817,-0.1765776320414517,-0.0023479513820377357,0.25922061836695104,
                  168,0.9498690817844185,-0.17477568441386393,-0.0028617402162054856,0.25921805116663127,
                  169,0.9501960049482804,-0.17299144280495451,-0.003370160364465538,0.2592106381221755,
                  170,0.9505188521918095,-0.17121666451349948,-0.003870984481635295,0.25919834278015697,
                  171,0.9508316975817522,-0.16945961361892853,-0.004369466586306686,0.25919766586078286,
                  172,0.9511414490035699,-0.16772044165558705,-0.004861158548527325,0.2591836541447211,
                  173,0.9514451521971788,-0.16599081431588902,-0.005346775280347313,0.2591728842246747,
                  174,0.9517406829255818,-0.16428520880384118,-0.005839161214157811,0.2591639381336463,
                  175,0.9520333768440379,-0.16258311790897292,-0.006313439156638845,0.2591511520945848,
                  176,0.9523181145659918,-0.16090511929100632,-0.006794497605014216,0.25914008963824414,
                  177,0.9525971690549934,-0.15923678901803814,-0.007269470907090388,0.25913207698848917,
                  178,0.952873135277245,-0.15758877674253613,-0.0077295214312821945,0.25911159759869407,
                  179,0.9531406061260248,-0.15595657877643873,-0.008195483486329161,0.2591010701260956,
                  180,0.9534049293670853,-0.15433421590285454,-0.008654012835708977,0.2590851182951921,
                  181,0.9536645097476172,-0.15271946122899074,-0.009114818354568873,0.2590708186888809,
                  182,0.9539178419961201,-0.15113343262889703,-0.009564408615633445,0.2590520379211585,
                  183,0.9541660334067437,-0.14955725654653335,-0.010007940986964795,0.2590359990895416,
                  184,0.9544097180519316,-0.1479887638465222,-0.010453754066614265,0.2590214950329903,
                  185,0.954648085223924,-0.14644691799511375,-0.010896737218612687,0.25900114807856894,
                  186,0.954882272713673,-0.1449088614653474,-0.011323055700358756,0.25898466274201287,
                  187,0.9551119139602477,-0.143395326756086,-0.011754928999409222,0.25896106603102853,
                  188,0.955335083081045,-0.14188946296528993,-0.012190348508285848,0.25894720453637116,
                  189,0.9555575654803491,-0.14039600647841172,-0.01260888732871332,0.25892028962310754,
                  190,0.9557719712527825,-0.13892079944446192,-0.013024863167529668,0.2589040428204032,
                  191,0.9559834207359865,-0.13746188228691267,-0.013444186799913951,0.25888063665973526,
                  192,0.9561899408645073,-0.1360152353172344,-0.01384910455700318,0.2588606865750315,
                  193,0.9563914068953313,-0.13458480590125466,-0.014258582175673065,0.25884184296908047,
                  194,0.9565908438013533,-0.1331646030581782,-0.01466083484695696,0.2588169352445142,
                  195,0.9567860560849788,-0.1317545221281893,-0.015057042416214347,0.2587942701332484,
                  196,0.9569764207973005,-0.1303607134561913,-0.015457818510157276,0.25877262272521806,
                  197,0.9571633826100091,-0.1289877673021047,-0.015845306775773685,0.25874570746229786,
                  198,0.9573467888885282,-0.12762278245232422,-0.016235117516083288,0.25871987199129015,
                  199,0.9575251474080023,-0.12627634619344183,-0.01662113943391806,0.25869598798055565,
                  200,0.9576996443157736,-0.12494011986170822,-0.017001108250623655,0.25867415805339633,
                  201,0.9578725968083167,-0.12361426893184332,-0.017373939117243185,0.25864598786698445,
                  202,0.9580407396005305,-0.12230702222642145,-0.01774298468647236,0.2586196436355717,
                  203,0.958204557057643,-0.12101616904659271,-0.018116607868456543,0.25859408767911407,
                  204,0.958365439911536,-0.11972945437951071,-0.01847355115567738,0.2585715940408989,
                  205,0.9585233418333389,-0.11846768726851731,-0.018836284587143676,0.2585413015687229,
                  206,0.9586769174404796,-0.11720545999910317,-0.019200114775583463,0.2585204125515493,
                  207,0.9588279375098411,-0.11596431014413519,-0.019550747968178288,0.25849377802435414,
                  208,0.9589746091389311,-0.11474185759530661,-0.01989758338467236,0.2584687434059737,
                  209,0.9591206085227708,-0.11352768781123111,-0.02024574417574865,0.2584361279889397,
                  210,0.9592611211343189,-0.11232369480005838,-0.020588843923895553,0.2584135998210437,
                  211,0.9594007118236938,-0.1111302453089259,-0.020924906617429143,0.2583843861629793,
                  212,0.9595365394071865,-0.10995330677744802,-0.021265550110711292,0.2583557165027975,
                  213,0.9596680409889629,-0.10879737045643229,-0.02159401447827135,0.2583294056527141,
                  214,0.9597978100273202,-0.10764121757834813,-0.021922542034498088,0.2583039571817601,
                  215,0.9599259441688861,-0.10650404158283527,-0.022246329676630684,0.25827150763085144,
                  216,0.9600492263430078,-0.10537484773401648,-0.022573368015523614,0.2582480736030005,
                  217,0.9601707182615625,-0.10426690111538994,-0.022887296286706226,0.25821846718148,
                  218,0.9602897184270979,-0.1031671509847043,-0.023203547734955775,0.25818944791260573,
                  219,0.9604059869822132,-0.10207784911438073,-0.023513737341186572,0.2581618814719796,
                  220,0.96051869201054485,-0.10100738558709356,-0.023820113579691427,0.25813553134790057,
                  221,0.9606312893651467,-0.09994535064637808,-0.024127931399397534,0.258101328363909,
                  222,0.960739054041394,-0.09889357959050264,-0.024430557498875006,0.25807688353612485,
                  223,0.9608465384623213,-0.09785250340656143,-0.02472625267324193,0.2580454020725478,
                  224,0.9609484410144825,-0.09683008606706327,-0.025018981735903698,0.2580234072656574,
                  225,0.9610504023095928,-0.09581613366068101,-0.025313176794583843,0.25799348021113766,
                  226,0.9611499759054367,-0.09481268639532492,-0.02560130237996256,0.2579648263464034,
                  227,0.9612472075737566,-0.09381975066865443,-0.025883354839202965,0.2579374192675326,
                  228,0.961341332349519,-0.09284572198221305,-0.02616158132550047,0.2579110045899602,
                  229,0.9614356742343593,-0.09188019618402483,-0.026441314798412895,0.2578765804225726,
                  230,0.9615255617957791,-0.09092497206725361,-0.02671577569524708,0.25785172250128974,
                  231,0.9615223873297151,-0.09095853558564296,-0.02672477640204825,0.25785078978770143,
                  232,0.9615192116920652,-0.0909920989932021,-0.026733777076286082,0.2578498567599297,
                  233,0.9615160348828334,-0.09102566228989023,-0.026742777717949633,0.25784892341797594,
                  234,0.9615257316327005,-0.09092146972771054,-0.026795785232961625,0.2578440219289601,
                  235,0.9615362040822879,-0.09080888462329026,-0.02684654356947425,0.25783936435476873,
                  236,0.9615464646758723,-0.09069855176643807,-0.02688891286276409,0.2578355199383146,
                  237,0.9615561100804,-0.09059435444506382,-0.0269419230866429,0.2578306476936467,
                  238,0.9615685867439352,-0.09048425393648879,-0.026983504490250526,0.2578184308040312,
                  239,0.9615789871410607,-0.09037166261728373,-0.0270342675408935,0.2578138135614285,
                  240,0.9615893688511769,-0.09025906957842726,-0.027085031559323583,0.2578092068500706,
              ]
            }
          }
        ]
  
      var dataSourcePromise = viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));
  
      dataSourcePromise.then(function (dataSource) {
        viewer.trackedEntity = dataSource.entities.getById('Vulcan');
      }).catch(function (error) {
        console.error(error);
      });
      
  };
  document.head.appendChild(script);

  const link = document.createElement('link');
  link.rel = 'stylesheet';
  link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
  document.head.appendChild(link);
}
