export function addPoint() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        const czml = [
            {
              id: "document",
              name: "CZML Point",
              version: "1.0",
            },
            {
              id: "point 1",
              name: "point",
              position: {
                cartographicDegrees: [-111.0, 40.0, 0],
              },
              point: {
                color: {
                  rgba: [255, 255, 255, 255],
                },
                outlineColor: {
                  rgba: [255, 0, 0, 255],
                },
                outlineWidth: 4,
                pixelSize: 20,
              },
            },
          ];
          
          const dataSourcePromise = Cesium.CzmlDataSource.load(czml);
          viewer.dataSources.add(dataSourcePromise);
          viewer.zoomTo(dataSourcePromise);
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
