import vueCodePoint from '@/examples/point.vue?raw'
import vueCodeLine from '@/examples/line.vue?raw'
import vueCodeMultiLine from '@/examples/multiLine.vue?raw'
import vueCodeCodeCirclesAndEllipses from '@/examples/circlesAndEllipses.vue?raw'

import vueCodeRain from '@/examples/rain.vue?raw'
import vueCodeSnow from '@/examples/snow.vue?raw'
import vueCodeFog from '@/examples/fog.vue?raw'
import vueCodeWaterSurface from '@/examples/waterSurface.vue?raw'

const vueCodeMap = {
    点: vueCodePoint,
    线: vueCodeLine,
    多颜色线: vueCodeMultiLine,
    椭圆: vueCodeCodeCirclesAndEllipses,

    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog,
    水面: vueCodeWaterSurface
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}