import vueCodePoint from '@/examples/graphicElement/point/point.vue?raw'
import vueCodeLine from '@/examples/graphicElement/line/line.vue?raw'
import vueCodeMultiLine from '@/examples/graphicElement/multiLine/multiLine.vue?raw'
import vueCodePlane from '@/examples/graphicElement/plane/plane.vue?raw'
import vueCodeCirclesAndEllipses from '@/examples/graphicElement/circlesAndEllipses/circlesAndEllipses.vue?raw'

import vueCodeBox from '@/examples/graphicElement/box/box.vue?raw'
import vueCodeStraightArrow from '@/examples/graphicElement/straightArrow/straightArrow.vue?raw'

import vueCodeRain from '@/examples/weather/rain/rain.vue?raw'
import vueCodeSnow from '@/examples/weather/snow/snow.vue?raw'
import vueCodeFog from '@/examples/weather/fog/fog.vue?raw'
import vueCodeWaterSurface from '@/examples/weather/waterSurface/waterSurface.vue?raw'

import vueCodeAircraft from '@/examples/movingTarget/aircraft/aircraft.vue?raw'
import vueCodeRocket from '@/examples/movingTarget/rocket/rocket.vue?raw'

const vueCodeMap = {
    点: vueCodePoint,
    线: vueCodeLine,
    多颜色线: vueCodeMultiLine,
    面: vueCodePlane,
    椭圆: vueCodeCirclesAndEllipses,
    盒子: vueCodeBox,
    直线箭头: vueCodeStraightArrow,

    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog,
    水面: vueCodeWaterSurface,

    飞机: vueCodeAircraft,
    火箭发射: vueCodeRocket
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}