export function addColumnBody() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        const czml = [
            {
              id: "document",
              name: "box",
              version: "1.0",
            },
            {
              id: "shape1",
              name: "Blue box",
              position: {
                cartographicDegrees: [-114.0, 40.0, 300000.0],
              },
              box: {
                dimensions: {
                  cartesian: [400000.0, 300000.0, 500000.0],
                },
                material: {
                  solidColor: {
                    color: {
                      rgba: [0, 0, 255, 255],
                    },
                  },
                },
              },
            },
            {
              id: "shape2",
              name: "Red box with black outline",
              position: {
                cartographicDegrees: [-107.0, 40.0, 300000.0],
              },
              box: {
                dimensions: {
                  cartesian: [400000.0, 300000.0, 500000.0],
                },
                material: {
                  solidColor: {
                    color: {
                      rgba: [255, 0, 0, 128],
                    },
                  },
                },
                outline: true,
                outlineColor: {
                  rgba: [0, 0, 0, 255],
                },
              },
            },
            {
              id: "shape3",
              name: "Yellow box outline",
              position: {
                cartographicDegrees: [-100.0, 40.0, 300000.0],
              },
              box: {
                dimensions: {
                  cartesian: [400000.0, 300000.0, 500000.0],
                },
                fill: false,
                outline: true,
                outlineColor: {
                  rgba: [255, 255, 0, 255],
                },
              },
            },
          ];
          
          const dataSourcePromise = Cesium.CzmlDataSource.load(czml);
          viewer.dataSources.add(dataSourcePromise);
          viewer.zoomTo(dataSourcePromise);
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
