export function addFog() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        viewer.scene.postProcessStages.add(new Cesium.PostProcessStage({
            fragmentShader: `
                uniform sampler2D colorTexture;
                uniform sampler2D depthTexture;
                uniform float visibility;
                uniform vec4 fogColor;
                in vec2 v_textureCoordinates; 
                out vec4 fragColor;
                void main(void) 
                { 
                    vec4 origcolor = texture(colorTexture, v_textureCoordinates); 
                    float depth = czm_readDepth(depthTexture, v_textureCoordinates); 
                    vec4 depthcolor = texture(depthTexture, v_textureCoordinates); 
                    float f = visibility * (depthcolor.r - 0.3) / 0.2; 
                    if (f < 0.0) f = 0.0; 
                    else if (f > 1.0) f = 1.0; 
                    fragColor = mix(origcolor, fogColor, f); 
                }
            `,
            uniforms: {
                visibility: 0.1,
                fogColor: new Cesium.Color(0.8, 0.8, 0.8, 0.8),
            },
        }));        
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
