export function addPlane() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        const czml = [
            {
              id: "document",
              name: "CZML Colors",
              version: "1.0",
            },
            {
              id: "rgba",
              name: "Rectangle with outline using RGBA Colors",
              rectangle: {
                coordinates: {
                  wsenDegrees: [-120, 40, -110, 50],
                },
                fill: true,
                material: {
                  solidColor: {
                    color: {
                      rgba: [255, 0, 0, 100],
                    },
                  },
                },
                height: 0, // disables ground clamping, needed for outlines
                outline: true,
                outlineColor: {
                  rgba: [0, 0, 0, 255],
                },
              },
            },
            {
              id: "rgbaf",
              name: "Rectangle using RGBAF Colors",
              rectangle: {
                coordinates: { wsenDegrees: [-100, 40, -90, 50] },
                fill: true,
                material: {
                  solidColor: {
                    color: {
                      rgbaf: [1, 0, 0, 0.39],
                    },
                  },
                },
                height: 0, // disables ground clamping, needed for outlines
                outline: true,
                outlineColor: {
                  rgba: [0, 0, 0, 255],
                },
              },
            },
          ];
          
          const dataSourcePromise = Cesium.CzmlDataSource.load(czml);
          viewer.dataSources.add(dataSourcePromise);
          viewer.zoomTo(dataSourcePromise); 
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
