// 太空任务
import vueCodeMoonTrack from '@/examples/spaceMissions/moonTrack/moonTrack.vue?raw'

// 测站
import vueCodeAddStation from '@/examples/measureStation/addStation/addStation.vue?raw'
import vueCodeStationCoordinate from '@/examples/measureStation/stationCoordinate/stationCoordinate.vue?raw'

// 动目标
import vueCodeVehicle from '@/examples/movingTarget/vehicle/vehicle.vue?raw'
import vueCodeAircraft from '@/examples/movingTarget/aircraft/aircraft.vue?raw'
import vueCodeCoordinateAxis from '@/examples/movingTarget/coordinateAxis/coordinateAxis.vue?raw'
import vueCodeRocket from '@/examples/movingTarget/rocket/rocket.vue?raw'

// 图元
import vueCodePoint from '@/examples/graphicElement/point/point.vue?raw'
import vueCodeLine from '@/examples/graphicElement/line/line.vue?raw'
import vueCodeMultiLine from '@/examples/graphicElement/multiLine/multiLine.vue?raw'
import vueCodePlane from '@/examples/graphicElement/plane/plane.vue?raw'
import vueCodeCirclesAndEllipses from '@/examples/graphicElement/circlesAndEllipses/circlesAndEllipses.vue?raw'
import vueCodeBox from '@/examples/graphicElement/box/box.vue?raw'
import vueCodeStraightArrow from '@/examples/graphicElement/straightArrow/straightArrow.vue?raw'

// 场景设置
import vueCodeTerminatorLine from '@/examples/sceneSet/terminatorLine/terminatorLine.vue?raw'
import vueCodeJingweiNetwork3D from '@/examples/sceneSet/jingweiNetwork3D/jingweiNetwork3D.vue?raw'

// 天气
import vueCodeRain from '@/examples/weather/rain/rain.vue?raw'
import vueCodeSnow from '@/examples/weather/snow/snow.vue?raw'
import vueCodeFog from '@/examples/weather/fog/fog.vue?raw'
import vueCodeWaterSurface from '@/examples/weather/waterSurface/waterSurface.vue?raw'


const vueCodeMap = {
    // 太空任务
    月球轨道: vueCodeMoonTrack,


    // 测站
    添加测站: vueCodeAddStation,
    测站坐标系: vueCodeStationCoordinate,

    // 动目标
    车: vueCodeVehicle,
    飞机: vueCodeAircraft,
    坐标轴: vueCodeCoordinateAxis,
    火箭发射: vueCodeRocket,

    // 图元
    点: vueCodePoint,
    线: vueCodeLine,
    多颜色线: vueCodeMultiLine,
    面: vueCodePlane,
    椭圆: vueCodeCirclesAndEllipses,
    盒子: vueCodeBox,
    直线箭头: vueCodeStraightArrow,

    // 场景设置
    晨昏线: vueCodeTerminatorLine,
    经纬网络3D: vueCodeJingweiNetwork3D,

    // 天气
    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog,
    水面: vueCodeWaterSurface,
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}