export function addSkyBox() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        // 定义图片的URL
        const imageUrls = {
            positiveX: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_px.jpg',
            negativeX: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_mx.jpg',
            positiveY: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_py.jpg',
            negativeY: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_my.jpg',
            positiveZ: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_pz.jpg',
            negativeZ: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/tycho2t3_80_mz.jpg',
        };

        // 异步加载图片
        async function loadImages() {
            const sources = {};
            for (const [key, url] of Object.entries(imageUrls)) {
                const response = await fetch(url);
                const blob = await response.blob();
                const imageUrl = URL.createObjectURL(blob);
                sources[key] = imageUrl;
            }
            return sources;
        }

        // 设置SkyBox
        loadImages().then(sources => {
            viewer.scene.skyBox = new Cesium.SkyBox({
                sources: sources
            });
        });
        
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
