import functionCodePoint from '@/examples/point-function.js?raw'
import functionCodeLine from '@/examples/line-function.js?raw'
import functionCodeMultiLine from '@/examples/multiLine-function.js?raw'
import functionCodeCirclesAndEllipses from '@/examples/circlesAndEllipses-function.js?raw'

import functionCodeRain from '@/examples/rain-function.js?raw'
import functionCodeSnow from '@/examples/snow-function.js?raw'
import functionCodeFog from '@/examples/fog-function.js?raw'
import functionCodeWaterSurface from '@/examples/waterSurface-function.js?raw'

const functionCodeMap = {
    点: functionCodePoint,
    线: functionCodeLine,
    多颜色线: functionCodeMultiLine,
    椭圆: functionCodeCirclesAndEllipses,

    雨: functionCodeRain,
    雪: functionCodeSnow,
    雾: functionCodeFog,
    水面: functionCodeWaterSurface
}

export function findFunctionCodeById(id){
    if(!functionCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return functionCodeMap[id]
}