import functionCodePoint from '@/examples/graphicElement/point/point-function.js?raw'
import functionCodeLine from '@/examples/graphicElement/line/line-function.js?raw'
import functionCodeMultiLine from '@/examples/graphicElement/multiLine/multiLine-function.js?raw'
import functionCodePlane from '@/examples/graphicElement/plane/plane-function.js?raw'
import functionCodeCirclesAndEllipses from '@/examples/graphicElement/circlesAndEllipses/circlesAndEllipses-function.js?raw'

import functionBox from '@/examples/graphicElement/box/box-function.js?raw'
import functionStraightArrow from '@/examples/graphicElement/straightArrow/straightArrow-function.js?raw'

import functionCodeRain from '@/examples/weather/rain/rain-function.js?raw'
import functionCodeSnow from '@/examples/weather/snow/snow-function.js?raw'
import functionCodeFog from '@/examples/weather/fog/fog-function.js?raw'
import functionCodeWaterSurface from '@/examples/weather/waterSurface/waterSurface-function.js?raw'

import functionCodeRocket from '@/examples/movingTarget/rocket/rocket-function.js?raw'

const functionCodeMap = {
    点: functionCodePoint,
    线: functionCodeLine,
    多颜色线: functionCodeMultiLine,
    面: functionCodePlane,
    椭圆: functionCodeCirclesAndEllipses,
    盒子: functionBox,
    直线箭头: functionStraightArrow,

    雨: functionCodeRain,
    雪: functionCodeSnow,
    雾: functionCodeFog,
    水面: functionCodeWaterSurface,

    火箭发射: functionCodeRocket
}

export function findFunctionCodeById(id){
    if(!functionCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return functionCodeMap[id]
}