export function addPlane() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        const czml = [
            {
              id: "document",
              name: "CZML Geometries: Circles and Ellipses",
              version: "1.0",
            },
            {
              id: "shape1",
              name: "Green circle at height",
              position: {
                cartographicDegrees: [-111.0, 40.0, 150000.0],
              },
              ellipse: {
                semiMinorAxis: 300000.0,
                semiMajorAxis: 300000.0,
                height: 200000.0,
                material: {
                  solidColor: {
                    color: {
                      rgba: [0, 255, 0, 255],
                    },
                  },
                },
              },
            },
            {
              id: "shape2",
              name: "Red ellipse with white outline on surface",
              position: {
                cartographicDegrees: [-103.0, 40.0, 0],
              },
              ellipse: {
                semiMinorAxis: 250000.0,
                semiMajorAxis: 400000.0,
                height: 0,
                material: {
                  solidColor: {
                    color: {
                      rgba: [255, 0, 0, 127],
                    },
                  },
                },
                outline: true, // height must be set for outlines to display
                outlineColor: {
                  rgba: [255, 255, 255, 255],
                },
              },
            },
            {
              id: "shape3",
              name:
                "Blue translucent, rotated, and extruded ellipse with outline",
              position: {
                cartographicDegrees: [-95.0, 40.0, 100000.0],
              },
              ellipse: {
                semiMinorAxis: 150000.0,
                semiMajorAxis: 300000.0,
                extrudedHeight: 200000.0,
                rotation: 0.78539,
                material: {
                  solidColor: {
                    color: {
                      rgba: [0, 0, 255, 127],
                    },
                  },
                },
                outline: true,
              },
            },
          ];
          
          const dataSourcePromise = Cesium.CzmlDataSource.load(czml);
          viewer.dataSources.add(dataSourcePromise);
          viewer.zoomTo(dataSourcePromise);
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
