export function addSnow() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        viewer.scene.postProcessStages.add(new Cesium.PostProcessStage({
          fragmentShader: `
              uniform sampler2D colorTexture; 
              in vec2 v_textureCoordinates;
              uniform float snowSpeed;
              uniform float snowSize;
              float snow(vec2 uv,float scale)
              {
                  float time=czm_frameNumber*snowSpeed;
                  float w=smoothstep(1.,0.,-uv.y*(scale/10.));if(w<.1)return 0.;
                  uv+=time/scale;uv.y+=time*2./scale;uv.x+=sin(uv.y+time*.5)/scale;
                  uv*=scale;vec2 s=floor(uv),f=fract(uv),p;float k=3.,d;
                  p=.5+.35*sin(11.*fract(sin((s+p+scale)*mat2(7,3,6,5))*5.))-f;d=length(p);k=min(d,k);
                  k=smoothstep(0.,k,sin(f.x+f.y)*snowSize);
                  return k*w;
              }
              out vec4 fragColor;
              void main(void){
                  vec2 resolution=czm_viewport.zw;
                  vec2 uv=(gl_FragCoord.xy*2.-resolution.xy)/min(resolution.x,resolution.y);
                  vec3 finalColor=vec3(0);
                  float c=0.;
                  c+=snow(uv,30.)*.0;
                  c+=snow(uv,20.)*.0;
                  c+=snow(uv,15.)*.0;
                  c+=snow(uv,10.);
                  c+=snow(uv,8.);
                  c+=snow(uv,6.);
                  c+=snow(uv,5.);
                  finalColor=(vec3(c));
                  fragColor=mix(texture(colorTexture,v_textureCoordinates),vec4(finalColor,1),.5);
              }
          `,
          uniforms: {
              snowSize: 0.02,
              snowSpeed: 0.005
          },
      }));
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
