export function addWaterSurface() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        viewer.scene.primitives.add(
            new Cesium.Primitive({
                geometryInstances: new Cesium.GeometryInstance({
                    geometry: new Cesium.RectangleGeometry({
                        rectangle: Cesium.Rectangle.fromDegrees(
                            100,
                            30,
                            101,
                            31
                        ),
                        vertexFormat: Cesium.EllipsoidSurfaceAppearance.VERTEX_FORMAT,
                        height: 0,
                    }),
                }),
                appearance: new Cesium.EllipsoidSurfaceAppearance({
                    material: new Cesium.Material({
                        fabric: {
                            type: "Water",
                            uniforms: {
                                baseWaterColor: new Cesium.Color(
                                    64 / 255.0,
                                    157 / 255.0,
                                    253 / 255.0,
                                    0.6
                                ),
                                normalMap: "https://webgishome-pic.oss-cn-chengdu.aliyuncs.com/cesium/waterMaterial.jpg",
                                frequency: 1000.0,
                                animationSpeed: 0.1,
                                amplitude: 10,
                                specularIntensity: 8,
                            },
                        },
                    }),
                }),
            })
        );

        viewer.camera.setView({
            destination: Cesium.Cartesian3.fromDegrees(100.5, 30.5, 150000),
            orientation: {
                heading: 6.283185, //相机绕z轴旋转。左右摇头。
                pitch: 30, //相机绕y轴旋转。上下点头。
                roll: 0.0, //相机绕x轴旋转。左右歪头。
            },
        });
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
