import vueCodePoint from '@/examples/point.vue?raw'
import vueCodeLine from '@/examples/line.vue?raw'
import vueCodeMultiLine from '@/examples/multiLine.vue?raw'
import vueCodePlane from '@/examples/plane.vue?raw'
import vueCodeCirclesAndEllipses from '@/examples/circlesAndEllipses.vue?raw'

import vueCodeBox from '@/examples/box.vue?raw'

import vueCodeRain from '@/examples/rain.vue?raw'
import vueCodeSnow from '@/examples/snow.vue?raw'
import vueCodeFog from '@/examples/fog.vue?raw'
import vueCodeWaterSurface from '@/examples/waterSurface.vue?raw'

const vueCodeMap = {
    点: vueCodePoint,
    线: vueCodeLine,
    多颜色线: vueCodeMultiLine,
    面: vueCodePlane,
    椭圆: vueCodeCirclesAndEllipses,
    盒子: vueCodeBox,

    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog,
    水面: vueCodeWaterSurface
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}