export function addRobotArmAnimation() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
            shouldAnimate: true
        });

        const czml = [
            {
                id: "document",
                name: "robotArm",
                version: "1.0",
                clock: {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:20:00Z",
                  currentTime: "2019-08-28T04:00:00.00Z",
                  multiplier: 1,
                  range: "LOOP_STOP",
                  step: "SYSTEM_CLOCK_MULTIPLIER"
                 }
            },
            {
                id: "robotArm",
                name: "robotArmAnimation",
                description: "<p>this is a ship</p>",
                availability: "2019-08-28T04:00:00Z/2019-08-28T04:20:00Z",
                position: {
                    cartographicDegrees: [120, 30, 0]
                },
                model: {
                    show: true,
                    gltf: [
                        {
                            interval: "2019-08-28T04:00:00Z/9999-12-31T23:59:59.9999999Z",
                            uri: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/3Dmodel/Station.glb'
                        }
                    ],
                    minimumPixelSize: 128,
                    scale: 1,
                    runAnimations: true
                }
            },
        ];

        var dataSourcePromise = viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));
        dataSourcePromise.then(function (dataSource) {
            // 根据模型所在的实体去进行加载
            viewer.trackedEntity = dataSource.entities.getById('robotArm');
        }).catch(function (error) {
          console.error(error);
        });

    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
