import { ref } from 'vue';
let viewer
export var bei = ref(1)
export var timetext = ref('')
export function addDial() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'
        viewer = new window.Cesium.Viewer('cesiumContainer', {
                animation: false,
                baseLayerPicker: false,
                fullscreenButton: false,
                vrButton :false,
                geocoder:false,
                homeButton:false,
                infoBox:false,
                sceneModePicker:false,
                selectionIndicator:false,
                timeline:true,
                navigationHelpButton:false,
        });
      


         // 格式化时间轴
        viewer.timeline.makeLabel = function (date) {
        const julianDT = new Cesium.JulianDate();
        Cesium.JulianDate.addHours(date, 8, julianDT);
        var gregorianDT = Cesium.JulianDate.toGregorianDate(julianDT);
        let hour = gregorianDT.hour + "";
        let minute = gregorianDT.minute + "";
        let second = gregorianDT.second + "";
        timetext.value = `${gregorianDT.year}年${gregorianDT.month}月${gregorianDT.day}日${hour.padStart(2, "0")}:${minute.padStart(2, "0")}:${second.padStart(2,"0")}`
        return `${gregorianDT.year}年${gregorianDT.month}月${gregorianDT.day}日${hour.padStart(2, "0")}:${minute.padStart(2, "0")}:${second.padStart(2,"0")}`;
        };


    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
export function forward() {
  let t = viewer.clockViewModel.multiplier;
  viewer.clockViewModel.multiplier = Math.abs(t);
}
var flag = false;
export function start() {
   flag = !(flag);
  if(flag==true)
    viewer.clock.shouldAnimate = true;
  else
    viewer.clock.shouldAnimate = false;
}
export function back() {
  let t = viewer.clockViewModel.multiplier;
  viewer.clockViewModel.multiplier = -Math.abs(t);
}
export function multiplier() {
  viewer.clockViewModel.multiplier *= 2;
  bei.value = viewer.clockViewModel.multiplier
}

export function divide() {
  viewer.clockViewModel.multiplier /= 2;
  bei.value = viewer.clockViewModel.multiplier
}
export function reset() {
  viewer.clock.currentTime = viewer.clock.startTime;
}

