export function addMissileLaunch(viewer) {
    var czml =
      [
        {
          id: "document",
          name: "Missile",
          version: "1.0",
          clock: {
            interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
            currentTime: "2019-08-28T04:00:00.00Z",
            multiplier: 1,
            range: "LOOP_STOP",
            step: "SYSTEM_CLOCK_MULTIPLIER"
          }
        },     
        {
          id: "MissileLaunch",
          availability: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
          name: "MissileLaunch",
          path: {
            show: [
              {
                interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                boolean: true
              }
            ],
            width: 1,
            resolution: 86400,
            leadTime: [
              {
                interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                epoch: "2019-08-28T04:00:00Z",
                number: [
                  0, 1053,
                  1053, 0
                ]
              }
            ],
            trailTime: [
              {
                interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                epoch: "2019-08-28T04:00:00Z",
                number: [
                  0, 0,
                  1053, 1053
                ]
              }
            ],
            material: {
              solidColor: {
                color: [
                  {
                    rgba: [ 0, 255, 0, 255 ]
                  }
                ]
              }
            }
          },
          model: {
            show: true,
            gltf: [
              {
                interval: "2019-08-28T04:00:00Z/9999-12-31T23:59:59.9999999Z",
                uri: "https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/3Dmodel/MissileTwo.glb"
              }
            ],
            minimumPixelSize: 128,
            scale: 1,
            runAnimations: false,
            articulations: {
              "SRBFlames Size": {
                epoch: "2019-08-28T04:00:00Z",
                number: [
                    0, 1,
                    60, 1,
                    61, 0, 
                    1000,0
                ]
              },
            }
          },
          position: {
            interpolationAlgorithm: "LAGRANGE",
            interpolationDegree: 5,
            referenceFrame: "FIXED",
            epoch: "2019-08-28T04:00:00Z",
            cartesian: [
              0.000, 917843.164, -5530578.249, 3031358.548,
              5.000, 917858.034, -5530668.136, 3031408.144,
              10.000, 917904.041, -5530947.370, 3031562.198,
              15.000, 917995.379, -5531429.784, 3031827.039,
              20.000, 918185.888, -5532123.853, 3032201.781,
              25.000, 918522.148, -5533037.209, 3032685.775,
              30.000, 919039.536, -5534178.813, 3033280.277,
              35.000, 919765.781, -5535552.193, 3033984.231,
              40.000, 920725.932, -5537159.564, 3034796.104,
              45.000, 921951.333, -5539013.869, 3035719.776,
              50.000, 923478.083, -5541133.458, 3036761.666,
              55.000, 925347.644, -5543541.795, 3037930.491,
              60.000, 927605.957, -5546265.685, 3039236.339,
              65.000, 930159.431, -5549170.295, 3040612.213,
              70.000, 932893.237, -5552105.857, 3041984.985,
              75.000, 935823.252, -5555076.264, 3043355.017,
              80.000, 938964.862, -5558083.710, 3044721.750,
              85.000, 942333.298, -5561129.288, 3046084.004,
              90.000, 945943.826, -5564213.327, 3047440.156,
              95.000, 949811.859, -5567335.599, 3048788.235,
              100.000, 953953.060, -5570495.476, 3050126.007,
              105.000, 958383.411, -5573692.036, 3051451.024,
              110.000, 963119.273, -5576924.135, 3052760.660,
              115.000, 968177.426, -5580190.468, 3054052.136,
              120.000, 973575.121, -5583489.609, 3055322.543,
              125.000, 979330.120, -5586820.054, 3056568.856,
              130.000, 985460.755, -5590180.254, 3057787.947,
              135.000, 991985.993, -5593568.654, 3058976.602,
              140.000, 998925.515, -5596983.723, 3060131.528,
              145.000, 1006299.806, -5600423.996, 3061249.362,
              150.000, 1014130.264, -5603888.099, 3062326.677,
              155.000, 1022439.320, -5607374.791, 3063359.991,
              160.000, 1031250.582, -5610882.993, 3064345.765,
              165.000, 1040588.998, -5614411.827, 3065280.405,
              170.000, 1050481.047, -5617960.649, 3066160.261,
              175.000, 1060954.957, -5621529.087, 3066981.622,
              180.000, 1072040.964, -5625117.088, 3067740.708,
              185.000, 1083771.619, -5628724.957, 3068433.661,
              190.000, 1096182.138, -5632353.415, 3069056.535,
              195.000, 1109310.838, -5636003.654, 3069605.272,
              200.000, 1123199.643, -5639677.407, 3070075.687,
              205.000, 1137894.713, -5643377.031, 3070463.435,
              210.000, 1153447.204, -5647105.606, 3070763.982,
              215.000, 1169914.223, -5650867.058, 3070972.558,
              220.000, 1187360.015, -5654666.310, 3071084.105,
              225.000, 1205857.496, -5658509.476, 3071093.203,
              230.000, 1225490.224, -5662404.112, 3070993.980,
              235.000, 1245704.746, -5666236.399, 3070784.103,
              240.000, 1265936.771, -5669896.839, 3070465.398
            ]
          },
          orientation: {
            "interpolationAlgorithm": "LINEAR",
            "interpolationDegree": 1,
            "epoch": "2019-08-28T04:00:00Z",
            "velocityReference": "#position"  // 方向的参考属性，指向实体的位置属性
          }
        }
      ]

    var dataSourcePromise = viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));

    dataSourcePromise.then(function (dataSource) {
      viewer.trackedEntity = dataSource.entities.getById('MissileLaunch');
    }).catch(function (error) {
      console.error(error);
    });
}
  