let viewer;
export function addCameraZoom() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });
 
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}

// 获取视图中心点
function  pickCenter() {
    var ellipsoid = viewer.camera.pickEllipsoid(new Cesium.Cartesian2(
        viewer.canvas.clientWidth / 2,
        viewer.canvas.clientHeight / 2));
    var curPosition = Cesium.Ellipsoid.WGS84.cartesianToCartographic(ellipsoid);
    var lon = curPosition.longitude * 180 / Math.PI;
    var lat = curPosition.latitude * 180 / Math.PI;
    return {
        lon: lon,
        lat: lat
    };
}
export function zoomByBound(flag){
    const center = pickCenter()
    var height = viewer.camera.positionCartographic.height;
    const camera = viewer.camera;
    var boundingSph = new Cesium.BoundingSphere(Cesium.Cartesian3.fromDegrees(center.lon, center.lat, 1000), height);
    var moveRate = 0;
    if(flag){
        moveRate = 0.5
    }
    else{
        moveRate = 1.5
    }
    var zoomParams = {
        duration: 0.8,
        offset: new Cesium.HeadingPitchRange(camera.heading, camera.pitch, height * moveRate)
    }
    camera.flyToBoundingSphere(boundingSph,zoomParams);
}
