let viewer;  // 全局声明viewer

export function addSceneScreenshot() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        viewer = new window.Cesium.Viewer('cesiumContainer', {
            navigationHelpButton: false, // 是否显示帮助信息控件
            infoBox: true,  // 是否显示点击要素之后显示的信息
            fullscreenButton: false, // 全屏显示
            CreditsDisplay: false,
            contextOptions: {
                webgl: {
                    alpha: true,
                    depth: true,
                    stencil: true,
                    antialias: true,
                    premultipliedAlpha: true,
                    // 通过canvas.toDataURL()实现截图需要将该项设置为true
                    preserveDrawingBuffer: true,
                    failIfMajorPerformanceCaveat: true
                }
            }
        });
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}

export function exportImage(){
    // 获取场景的canvas
    const canvas = viewer.scene.canvas;
    // 创建一个临时的a标签用于下载图片
    const a = document.createElement('a');
    a.href = canvas.toDataURL('image/png');
    a.download = 'screenshot.png';
    // 模拟点击a标签进行下载
    a.click();
}