import vueCodePoint from '@/examples/point.vue?raw'
import vueCodeLine from '@/examples/line.vue?raw'
import vueCodePlane from '@/examples/plane.vue?raw'

import vueCodeRain from '@/examples/rain.vue?raw'
import vueCodeSnow from '@/examples/snow.vue?raw'
import vueCodeFog from '@/examples/fog.vue?raw'

const vueCodeMap = {
    点: vueCodePoint,
    多线: vueCodeLine,
    多面: vueCodePlane,

    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}