export function addRocket() {
  const script = document.createElement('script');
  script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
  script.onload = () => {
      window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

      var viewer = new Cesium.Viewer('cesiumContainer', {
        shouldAnimate: true  // 一开始就播放动画
      });    
  
      var czml =
        [
          {
            id: "document",
            name: "SpaceX",
            version: "1.0",
            clock: {
              interval: "2019-08-28T04:00:00Z/2019-08-28T04:17:33Z",
              currentTime: "2019-08-28T04:00:00.00Z",
              multiplier: 1,
              range: "LOOP_STOP",
              step: "SYSTEM_CLOCK_MULTIPLIER"
            }
          },     
          {
            id: "Vulcan",
            availability: "2019-08-28T04:00:00Z/2019-08-28T04:17:33Z",
            name: "Vulcan",
            path: {
              show: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:17:33Z",
                  boolean: true
                }
              ],
              width: 1,
              resolution: 86400,
              leadTime: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:17:33Z",
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1053,
                    1053, 0
                  ]
                }
              ],
              trailTime: [
                {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:17:33Z",
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    1053, 1053
                  ]
                }
              ],
              material: {
                solidColor: {
                  color: [
                    {
                      rgba: [ 0, 255, 0, 255 ]
                    }
                  ]
                }
              }
            },
            model: {
              show: true,
              gltf: [
                {
                  interval: "2019-08-28T04:00:00Z/9999-12-31T23:59:59.9999999Z",
                  uri: "https://cesium.com/public/SandcastleSampleData/launchvehicle.glb"
                }
              ],
              minimumPixelSize: 128,
              scale: 1,
              runAnimations: false,
              articulations: {   // 定义动画参数
                "BoosterFlames Size": {   // 二级发动机底部火焰样式的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    180, 1,
                    182, 0,
                    1000,0                  
                  ]
                },
                "Booster MoveZ": {  // 二级发动机随着z轴向下掉落的情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    180, 0,
                    200, -300,
                    1000,-300
                  ]
                },
                "Booster Yaw": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    190, 0,
                    200, 90,
                    1000, 90
                  ]
                },
                "Booster Size": {  // 二级发动机随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    200, 1,
                    201, 0,
                    1000,0
                  ]
                },
                "InterstageAdapter MoveZ": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    180, 0,
                    200, -300,
                    1000,-300
                  ]
                },
                "InterstageAdapter Size": {
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    190, 1,
                    191, 0, 
                    1000,0
                  ]
                },
  
                "SRBFlames Size": {   // 一级助推器底部火焰随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    60, 1,
                    61, 0, 
                    1000,0
                  ]
                },
                "SRBs Separate": {  // 一级助推器分开的距离
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    61, 0,
                    71, 40,
                    1000,40
                  ]
                },
                "SRBs Drop": {  // 一级助推器掉落：随时间的变化掉落的距离，负号表示向下掉落
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    61, 0,
                    71, -150,
                    1000,-150
                  ]
                },
                "SRBs Rotate": {  // 一级助推器掉落的张开角度随时间的变化，张开的角度单位为度
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    61, 0,
                    71, 120,
                    1000,120
                  ]
                },
                "SRBs Size": {  // 一级助推器的显示和消失情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,1,
                    70, 1,
                    71, 0, 
                    1000,0
                  ]
                },
                "UpperStageFlames Size": {   // 顶部卫星仓助推器底部火焰随时间变化的显示情况
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0,0,
                    181, 0,
                    182, 1,
                    1000,1,
                    1001,0,
                    1050,0
                  ]
                },
                "Fairing Open": {  // 整流罩随时间的变化而打开的角度
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    200, 0,
                    210, 120,  // 第210秒时，打开的角度为120度
                    1000,120
                  ]
                },
                "Fairing Separate": {  // 整流罩分离：随时间的变化分离出去的距离，负号表示往外部分离
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    200, 0,
                    210, -50,
                    1000,-50
                  ]
                },
                "Fairing Drop": {  // 整流罩掉落：随时间的变化掉落的距离，负号表示向下掉落
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 0,
                    202, 0,
                    210, -150,
                    1000,-150
                  ]
                },
                "Fairing Size": {  // 整流罩的显示和消失：1表示显示，0表示消失
                  epoch: "2019-08-28T04:00:00Z",
                  number: [
                    0, 1,
                    215, 1,
                    216, 0, 
                    1000,0
                  ]
                }
  
              }
            },
            position: {
              interpolationAlgorithm: "LAGRANGE",
              interpolationDegree: 5,
              referenceFrame: "FIXED",
              epoch: "2019-08-28T04:00:00Z",
              cartesian: [
                0.000, 917843.164, -5530578.249, 3031358.548,
                5.000, 917858.034, -5530668.136, 3031408.144,
                10.000, 917904.041, -5530947.370, 3031562.198,
                15.000, 917995.379, -5531429.784, 3031827.039,
                20.000, 918185.888, -5532123.853, 3032201.781,
                25.000, 918522.148, -5533037.209, 3032685.775,
                30.000, 919039.536, -5534178.813, 3033280.277,
                35.000, 919765.781, -5535552.193, 3033984.231,
                40.000, 920725.932, -5537159.564, 3034796.104,
                45.000, 921951.333, -5539013.869, 3035719.776,
                50.000, 923478.083, -5541133.458, 3036761.666,
                55.000, 925347.644, -5543541.795, 3037930.491,
                60.000, 927605.957, -5546265.685, 3039236.339,
                65.000, 930159.431, -5549170.295, 3040612.213,
                70.000, 932893.237, -5552105.857, 3041984.985,
                75.000, 935823.252, -5555076.264, 3043355.017,
                80.000, 938964.862, -5558083.710, 3044721.750,
                85.000, 942333.298, -5561129.288, 3046084.004,
                90.000, 945943.826, -5564213.327, 3047440.156,
                95.000, 949811.859, -5567335.599, 3048788.235,
                100.000, 953953.060, -5570495.476, 3050126.007,
                105.000, 958383.411, -5573692.036, 3051451.024,
                110.000, 963119.273, -5576924.135, 3052760.660,
                115.000, 968177.426, -5580190.468, 3054052.136,
                120.000, 973575.121, -5583489.609, 3055322.543,
                125.000, 979330.120, -5586820.054, 3056568.856,
                130.000, 985460.755, -5590180.254, 3057787.947,
                135.000, 991985.993, -5593568.654, 3058976.602,
                140.000, 998925.515, -5596983.723, 3060131.528,
                145.000, 1006299.806, -5600423.996, 3061249.362,
                150.000, 1014130.264, -5603888.099, 3062326.677,
                155.000, 1022439.320, -5607374.791, 3063359.991,
                160.000, 1031250.582, -5610882.993, 3064345.765,
                165.000, 1040588.998, -5614411.827, 3065280.405,
                170.000, 1050481.047, -5617960.649, 3066160.261,
                175.000, 1060954.957, -5621529.087, 3066981.622,
                180.000, 1072040.964, -5625117.088, 3067740.708,
                185.000, 1083771.619, -5628724.957, 3068433.661,
                190.000, 1096182.138, -5632353.415, 3069056.535,
                195.000, 1109310.838, -5636003.654, 3069605.272,
                200.000, 1123199.643, -5639677.407, 3070075.687,
                205.000, 1137894.713, -5643377.031, 3070463.435,
                210.000, 1153447.204, -5647105.606, 3070763.982,
                215.000, 1169914.223, -5650867.058, 3070972.558,
                220.000, 1187360.015, -5654666.310, 3071084.105,
                225.000, 1205857.496, -5658509.476, 3071093.203,
                230.000, 1225490.224, -5662404.112, 3070993.980,
                235.000, 1245704.746, -5666236.399, 3070784.103,
                240.000, 1265936.771, -5669896.839, 3070465.398,
                245.000, 1286200.148, -5673388.627, 3070038.095,
                250.000, 1306494.726, -5676712.255, 3069502.479,
                255.000, 1326820.357, -5679868.207, 3068858.832,
                260.000, 1347176.894, -5682856.962, 3068107.431,
                265.000, 1367564.193, -5685678.987, 3067248.548,
                270.000, 1387982.108, -5688334.745, 3066282.451,
                275.000, 1408430.498, -5690824.689, 3065209.404,
                280.000, 1428909.221, -5693149.265, 3064029.667,
                285.000, 1449418.139, -5695308.914, 3062743.495,
                290.000, 1469957.113, -5697304.066, 3061351.141,
                295.000, 1490526.006, -5699135.148, 3059852.852,
                300.000, 1511124.681, -5700802.577, 3058248.871,
                305.000, 1531753.006, -5702306.766, 3056539.439,
                310.000, 1552410.845, -5703648.119, 3054724.792,
                315.000, 1573098.067, -5704827.034, 3052805.164,
                320.000, 1593814.541, -5705843.905, 3050780.782,
                325.000, 1614560.136, -5706699.118, 3048651.873,
                330.000, 1635334.723, -5707393.051, 3046418.660,
                335.000, 1656138.174, -5707926.079, 3044081.361,
                340.000, 1676970.362, -5708298.571, 3041640.191,
                345.000, 1697831.161, -5708510.889, 3039095.365,
                350.000, 1718720.444, -5708563.388, 3036447.090,
                355.000, 1739638.087, -5708456.422, 3033695.573,
                360.000, 1760583.968, -5708190.334, 3030841.017,
                365.000, 1781557.962, -5707765.467, 3027883.623,
                370.000, 1802559.947, -5707182.155, 3024823.589,
                375.000, 1823589.803, -5706440.729, 3021661.108,
                380.000, 1844647.408, -5705541.514, 3018396.373,
                385.000, 1865732.644, -5704484.830, 3015029.573,
                390.000, 1886845.390, -5703270.994, 3011560.895,
                395.000, 1907985.528, -5701900.316, 3007990.522,
                400.000, 1929152.942, -5700373.102, 3004318.637,
                405.000, 1950347.512, -5698689.656, 3000545.417,
                410.000, 1971569.125, -5696850.275, 2996671.041,
                415.000, 1992817.663, -5694855.252, 2992695.682,
                420.000, 2014093.011, -5692704.877, 2988619.512,
                425.000, 2035395.056, -5690399.435, 2984442.701,
                430.000, 2056723.684, -5687939.208, 2980165.418,
                435.000, 2078078.781, -5685324.473, 2975787.826,
                440.000, 2099460.235, -5682555.505, 2971310.091,
                445.000, 2120867.934, -5679632.574, 2966732.374,
                450.000, 2142301.768, -5676555.947, 2962054.834,
                455.000, 2163761.625, -5673325.886, 2957277.629,
                460.000, 2185247.396, -5669942.653, 2952400.914,
                465.000, 2206758.971, -5666406.504, 2947424.845,
                470.000, 2228296.243, -5662717.692, 2942349.574,
                475.000, 2249859.103, -5658876.469, 2937175.250,
                480.000, 2271447.444, -5654883.082, 2931902.025,
                485.000, 2293061.159, -5650737.777, 2926530.044,
                490.000, 2314700.143, -5646440.794, 2921059.455,
                495.000, 2336364.290, -5641992.375, 2915490.401,
                500.000, 2358053.497, -5637392.755, 2909823.027,
                505.000, 2379767.659, -5632642.171, 2904057.474,
                510.000, 2401506.674, -5627740.852, 2898193.882,
                515.000, 2423270.440, -5622689.031, 2892232.391,
                520.000, 2445058.855, -5617486.935, 2886173.140,
                525.000, 2466871.820, -5612134.788, 2880016.265,
                530.000, 2488709.234, -5606632.817, 2873761.902,
                535.000, 2510571.000, -5600981.241, 2867410.186,
                540.000, 2532457.019, -5595180.282, 2860961.251,
                545.000, 2554367.195, -5589230.158, 2854415.230,
                550.000, 2576301.433, -5583131.086, 2847772.255,
                555.000, 2598259.637, -5576883.281, 2841032.458,
                560.000, 2620241.715, -5570486.959, 2834195.968,
                565.000, 2642247.573, -5563942.331, 2827262.915,
                570.000, 2664277.122, -5557249.609, 2820233.429,
                575.000, 2686330.270, -5550409.005, 2813107.638,
                580.000, 2708406.929, -5543420.728, 2805885.670,
                585.000, 2730507.012, -5536284.986, 2798567.652,
                590.000, 2752630.433, -5529001.989, 2791153.710,
                595.000, 2774777.107, -5521571.942, 2783643.971,
                600.000, 2796946.952, -5513995.054, 2776038.561,
                605.000, 2819139.886, -5506271.531, 2768337.605,
                610.000, 2841355.829, -5498401.579, 2760541.229,
                615.000, 2863594.703, -5490385.403, 2752649.558,
                620.000, 2885856.432, -5482223.210, 2744662.717,
                625.000, 2908140.942, -5473915.205, 2736580.829,
                630.000, 2930448.159, -5465461.594, 2728404.021,
                635.000, 2952778.014, -5456862.583, 2720132.415,
                640.000, 2975130.438, -5448118.378, 2711766.138,
                645.000, 2997505.365, -5439229.186, 2703305.312,
                650.000, 3019902.730, -5430195.214, 2694750.063,
                655.000, 3042322.474, -5421016.665, 2686100.514,
                660.000, 3064764.548, -5411693.578, 2677356.691,
                665.000, 3087228.922, -5402225.774, 2668518.498,
                670.000, 3109715.566, -5392613.057, 2659585.827,
                675.000, 3132224.452, -5382855.226, 2650558.571,
                680.000, 3154755.551, -5372952.079, 2641436.618,
                685.000, 3177308.834, -5362903.407, 2632219.856,
                690.000, 3199884.274, -5352709.001, 2622908.171,
                695.000, 3222481.844, -5342368.646, 2613501.445,
                700.000, 3245101.516, -5331882.125, 2603999.562,
                705.000, 3267743.265, -5321249.218, 2594402.401,
                710.000, 3290407.066, -5310469.701, 2584709.840,
                715.000, 3313092.895, -5299543.346, 2574921.756,
                720.000, 3335800.727, -5288469.922, 2565038.024,
                725.000, 3358530.542, -5277249.197, 2555058.516,
                730.000, 3381282.316, -5265880.932, 2544983.103,
                735.000, 3404056.030, -5254364.889, 2534811.655,
                740.000, 3426851.666, -5242700.823, 2524544.040,
                745.000, 3449669.205, -5230888.488, 2514180.122,
                750.000, 3472508.631, -5218927.634, 2503719.766,
                755.000, 3495369.929, -5206818.010, 2493162.833,
                760.000, 3518253.088, -5194559.359, 2482509.185,
                765.000, 3541158.095, -5182151.422, 2471758.680,
                770.000, 3564084.941, -5169593.939, 2460911.175,
                775.000, 3587033.620, -5156886.643, 2449966.524,
                780.000, 3610004.125, -5144029.269, 2438924.581,
                785.000, 3632996.454, -5131021.545, 2427785.198,
                790.000, 3656010.606, -5117863.197, 2416548.223,
                795.000, 3679046.584, -5104553.949, 2405213.504,
                800.000, 3702104.393, -5091093.522, 2393780.888,
                805.000, 3725184.039, -5077481.634, 2382250.219,
                810.000, 3748285.533, -5063717.998, 2370621.338,
                815.000, 3771408.890, -5049802.329, 2358894.086,
                820.000, 3794554.125, -5035734.334, 2347068.301,
                825.000, 3817721.260, -5021513.719, 2335143.821,
                830.000, 3840910.318, -5007140.189, 2323120.478,
                835.000, 3864121.328, -4992613.443, 2310998.106,
                840.000, 3887354.322, -4977933.180, 2298776.535,
                845.000, 3910609.335, -4963099.093, 2286455.594,
                850.000, 3933886.408, -4948110.876, 2274035.109,
                855.000, 3957185.587, -4932968.216, 2261514.905,
                860.000, 3980506.922, -4917670.801, 2248894.802,
                865.000, 4003850.467, -4902218.313, 2236174.622,
                870.000, 4027216.284, -4886610.432, 2223354.182,
                875.000, 4050604.438, -4870846.836, 2210433.297,
                880.000, 4074015.002, -4854927.199, 2197411.780,
                885.000, 4097448.052, -4838851.191, 2184289.442,
                890.000, 4120903.674, -4822618.483, 2171066.091,
                895.000, 4144381.957, -4806228.738, 2157741.533,
                900.000, 4167883.000, -4789681.618, 2144315.570,
                905.000, 4191406.906, -4772976.782, 2130788.003,
                910.000, 4214953.789, -4756113.886, 2117158.630,
                915.000, 4238523.768, -4739092.581, 2103427.246,
                920.000, 4262116.970, -4721912.518, 2089593.641,
                925.000, 4285733.533, -4704573.340, 2075657.606,
                930.000, 4309373.600, -4687074.691, 2061618.926,
                935.000, 4333037.326, -4669416.208, 2047477.384,
                940.000, 4356724.875, -4651597.526, 2033232.759,
                945.000, 4380436.419, -4633618.276, 2018884.828,
                950.000, 4404172.141, -4615478.085, 2004433.362,
                955.000, 4427932.236, -4597176.576, 1989878.130,
                960.000, 4451716.907, -4578713.368, 1975218.898,
                965.000, 4475526.372, -4560088.076, 1960455.426,
                970.000, 4499360.857, -4541300.310, 1945587.472,
                975.000, 4523220.604, -4522349.676, 1930614.789,
                980.000, 4547105.863, -4503235.776, 1915537.126,
                985.000, 4571016.901, -4483958.206, 1900354.225,
                990.000, 4594953.998, -4464516.558, 1885065.828,
                995.000, 4618917.446, -4444910.417, 1869671.667,
                1000.000, 4642907.554, -4425139.366, 1854171.474,
                1005.000, 4666924.644, -4405202.980, 1838564.971,
                1010.000, 4690969.055, -4385100.828, 1822851.878,
                1015.000, 4715041.141, -4364832.474, 1807031.908,
                1020.000, 4739141.275, -4344397.476, 1791104.767,
                1025.000, 4763269.845, -4323795.385, 1775070.158,
                1030.000, 4787427.258, -4303025.746, 1758927.774,
                1035.000, 4811613.938, -4282088.095, 1742677.303,
                1040.000, 4835830.331, -4260981.963, 1726318.426,
                1045.000, 4860076.900, -4239706.872, 1709850.818,
                1050.000, 4884354.130, -4218262.337, 1693274.144,
                1053.000, 4898935.396, -4205314.077, 1683275.646
              ]
            },
            orientation: {  // 火箭的飞行方位
              "interpolationAlgorithm": "LINEAR",
              "interpolationDegree": 1,
              "epoch": "2019-08-28T04:00:00Z",
              "velocityReference": "#position"  // 方向的参考属性，指向实体的位置属性
            }
          }
        ]
  
      var dataSourcePromise = viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));
  
      dataSourcePromise.then(function (dataSource) {
        viewer.trackedEntity = dataSource.entities.getById('Vulcan');
      }).catch(function (error) {
        console.error(error);
      });
      
  };
  document.head.appendChild(script);

  const link = document.createElement('link');
  link.rel = 'stylesheet';
  link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
  document.head.appendChild(link);
}
