export function addearthCoordinate() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
        });

        // 获取地球的 globe 实例
        const globe = viewer.scene.globe;

        // 创建一个以地球球心为起点的坐标系
        const center = new Cesium.Cartesian3(0, 0, 0); // 地球球心的坐标
        const modelMatrix = Cesium.Transforms.eastNorthUpToFixedFrame(center);

        // 添加坐标轴图元
        viewer.scene.primitives.add(new Cesium.DebugModelMatrixPrimitive({
            modelMatrix: modelMatrix,
            length: 10000000, // 坐标轴的长度
            width: 2.0 // 坐标轴的宽度
        }));

    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
