export function addMissileMobileLaunch(startLon, startLat, startHeight, endLon, endLat, endHeight, missileId) {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        if (!window.CesiumInitialized) {
            window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'
            window.viewer = new Cesium.Viewer('cesiumContainer', {
                shouldAnimate: true  // 一开始就播放动画
            });
            window.CesiumInitialized = true;
        }

        const numPoints = 600; // 生成路径的点数

        const cartesianData = generateArcPath(startLon, startLat, startHeight, endLon, endLat, endHeight, numPoints);

        var czml =
            [
                {
                    id: "document",
                    name: "Missile",
                    version: "1.0",
                    clock: {
                        interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                        currentTime: "2019-08-28T04:00:00.00Z",
                        multiplier: 1,
                        range: "LOOP_STOP",
                        step: "SYSTEM_CLOCK_MULTIPLIER"
                    }
                },
                {
                    id: `MissileLaunch${missileId}`,
                    availability: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                    name: "MissileLaunch",
                    path: {
                        show: [
                            {
                                interval: "2019-08-28T04:00:00Z/2019-08-28T04:04:00Z",
                                boolean: true
                            }
                        ],
                        width: 1,
                        resolution: 86400,
                        leadTime: 0,
                        trailTime: 500,
                        material: {
                            solidColor: {
                                color: {
                                    rgba: [0, 255, 0, 255] // 设置轨迹颜色为绿色
                                }
                            }
                        }
                    },
                    model: {
                        show: true,
                        gltf: [
                            {
                                interval: "2019-08-28T04:00:00Z/9999-12-31T23:59:59.9999999Z",
                                uri: "https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/3Dmodel/MissileTwo.glb"
                            }
                        ],
                        minimumPixelSize: 128,
                        scale: 1,
                        runAnimations: false,
                        articulations: {
                            "SRBFlames Size": {
                                epoch: "2019-08-28T04:00:00Z",
                                number: [
                                    0, 1,
                                    60, 1,
                                    61, 0,
                                    1000, 0
                                ]
                            },
                        }
                    },
                    position: {
                        interpolationAlgorithm: "LAGRANGE",
                        interpolationDegree: 5,
                        referenceFrame: "FIXED",
                        epoch: "2019-08-28T04:00:00Z",
                        cartographicDegrees: cartesianData
                    },
                    orientation: {
                        "interpolationAlgorithm": "LINEAR",
                        "interpolationDegree": 1,
                        "epoch": "2019-08-28T04:00:00Z",
                        "velocityReference": "#position"  // 方向的参考属性，指向实体的位置属性
                    }
                }
            ]

        var dataSourcePromise = window.viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));

        dataSourcePromise.then(function (dataSource) {
            window.viewer.trackedEntity = dataSource.entities.getById(`MissileLaunch${missileId}`);
        }).catch(function (error) {
            console.error(error);
        });

    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}

// 路径生成函数，通过传入起点和终点的经纬和高度信息，生成路径数组
function generateArcPath(startLon, startLat, startHeight, endLon, endLat, endHeight, numPoints) {
    const startCartographic = new Cesium.Cartographic(Cesium.Math.toRadians(startLon), Cesium.Math.toRadians(startLat), startHeight);
    const endCartographic = new Cesium.Cartographic(Cesium.Math.toRadians(endLon), Cesium.Math.toRadians(endLat), endHeight);

    const geodesic = new Cesium.EllipsoidGeodesic(startCartographic, endCartographic);

    const cartesianArray = [];
    for (let i = 0; i <= numPoints; i++) {
        const fraction = i / numPoints;
        const intermediateCartographic = geodesic.interpolateUsingFraction(fraction);
        const intermediateHeight = Cesium.Math.lerp(startHeight, endHeight, fraction);
        const intermediatePosition = Cesium.Cartographic.toCartesian(intermediateCartographic);
        const cartographic = Cesium.Cartographic.fromCartesian(intermediatePosition);
        const lon = Cesium.Math.toDegrees(cartographic.longitude);
        const lat = Cesium.Math.toDegrees(cartographic.latitude);
        cartesianArray.push(i * (240 / numPoints), lon, lat, intermediateHeight);
    }
    return cartesianArray;
}