export function addVehicle() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        const viewer = new window.Cesium.Viewer('cesiumContainer', {
            infoBox: false,
            shouldAnimate: true
        });

        const czml = [
            {
                id: "document",
                name: "Vehicle",
                version: "1.0",
                clock: {
                  interval: "2019-08-28T04:00:00Z/2019-08-28T04:20:00Z",
                  currentTime: "2019-08-28T04:00:00.00Z",
                  multiplier: 1,
                  range: "LOOP_STOP",
                  step: "SYSTEM_CLOCK_MULTIPLIER"
                 }
            },
            {
                id: "path",
                name: "path for Vehicle",
                description: "<p>this is a description</p>",
                availability: "2019-08-28T04:00:00Z/2019-08-28T04:20:00Z",
                path: {
                    material: {
                        polylineOutline: {
                            color: {
                                rgba: [255, 0, 255, 255],
                            },
                            outlineColor: {
                                rgba: [0, 255, 255, 255],
                            },
                            outlineWidth: 5    
                        }, 
                    },
                    width: 8,   // 折线宽度
                    leadTime: 5,  
                    trailTime: 50000,
                    resolution: 5,
                 },
                 orientation: {
                    "velocityReference": "#position"
                 },
                 model: {
                     gltf: 'https://raw.githubusercontent.com/jinlinchao123/Cesium-assets/main/3Dmodel/CesiumMilkTruck.glb',
                     minimumPixelSize: 128,
                 },
                 position: {
                     epoch: "2019-08-28T04:00:00.00Z",
                     cartographicDegrees: [
                         0, 120, 30, 0,
                         1200, 121, 30, 0
                     ]
                 }
            },
        ];

        var dataSourcePromise = viewer.dataSources.add(Cesium.CzmlDataSource.load(czml));
        dataSourcePromise.then(function (dataSource) {
            // 根据模型所在的实体去进行加载
            viewer.trackedEntity = dataSource.entities.getById('path');
        }).catch(function (error) {
          console.error(error);
        });

    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
