import vueCodePoint from '@/examples/graphicElement/point.vue?raw'
import vueCodeLine from '@/examples/graphicElement/line.vue?raw'
import vueCodeMultiLine from '@/examples/graphicElement/multiLine.vue?raw'
import vueCodePlane from '@/examples/graphicElement/plane.vue?raw'
import vueCodeCirclesAndEllipses from '@/examples/graphicElement/circlesAndEllipses.vue?raw'

import vueCodeBox from '@/examples/graphicElement/box.vue?raw'
import vueCodeStraightArrow from '@/examples/graphicElement/straightArrow.vue?raw'

import vueCodeRain from '@/examples/weather/rain.vue?raw'
import vueCodeSnow from '@/examples/weather/snow.vue?raw'
import vueCodeFog from '@/examples/weather/fog.vue?raw'
import vueCodeWaterSurface from '@/examples/weather/waterSurface.vue?raw'

import vueCodeRocket from '@/examples/movingTarget/rocket.vue?raw'

const vueCodeMap = {
    点: vueCodePoint,
    线: vueCodeLine,
    多颜色线: vueCodeMultiLine,
    面: vueCodePlane,
    椭圆: vueCodeCirclesAndEllipses,
    盒子: vueCodeBox,
    直线箭头: vueCodeStraightArrow,

    雨: vueCodeRain,
    雪: vueCodeSnow,
    雾: vueCodeFog,
    水面: vueCodeWaterSurface,

    火箭发射: vueCodeRocket
}

export function findVueCodeById(id){
    if(!vueCodeMap.hasOwnProperty(id)){
        throw new Error(`${id}不存在`);
    } 
    return vueCodeMap[id]
}