export function addRocket() {
    const script = document.createElement('script');
    script.src = 'https://cesium.com/downloads/cesiumjs/releases/1.99/Build/Cesium/Cesium.js';
    script.onload = () => {
        window.Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiI3Njg4ZWU5Yi1iZDhiLTRhYmUtOTRiYS04YjM5NmUwNjVmMDMiLCJpZCI6MjI3MzQ3LCJpYXQiOjE3MjA1MjA4Mjh9.E5XW4LnwgfVAaBC-znaYr61m4yK0-j2qEQhi9qwFFPE'

        var viewer = new Cesium.Viewer('cesiumContainer', {
          shouldAnimate: true  // 一开始就播放动画
        });    
    
        const czml = [
          {
            id: "document",
            name: "CZML Model",
            version: "1.0",
            clock: {
              interval: "2019-06-01T16:00:00Z/2019-06-01T16:10:00Z",
              currentTime: "2019-06-01T16:00:00Z",
              multiplier: 60,
              range: "LOOP_STOP",
              step: "SYSTEM_CLOCK_MULTIPLIER",
            },
          },
          {
            id: "test model",
            name: "Cesium Air",
            position: {
              cartographicDegrees: [-77, 37, 10000],
            },
            model: {
              gltf:
                "https://cesium.com/public/SandcastleSampleData/launchvehicle.glb",
              scale: 2.0,
              minimumPixelSize: 128,
              runAnimations: false,
              articulations: {
                "Fairing Open": {
                  epoch: "2019-06-01T16:00:00Z",
                  number: [0, 0, 600, 120],
                },
                "Fairing Separate": {
                  epoch: "2019-06-01T16:00:00Z",
                  number: [0, 0, 400, -50],
                },
                "Fairing Drop": {
                  epoch: "2019-06-01T16:00:00Z",
                  interpolationAlgorithm: "LAGRANGE",
                  interpolationDegree: 2,
                  number: [0, 0, 80, 0, 100, 0, 120, -1, 600, -120],
                },
              },
            },
          },
        ];
        
        const dataSourcePromise = viewer.dataSources.add(
          Cesium.CzmlDataSource.load(czml)
        );
        
        dataSourcePromise
          .then(function (dataSource) {
            viewer.trackedEntity = dataSource.entities.getById("test model");
          })
          .catch(function (error) {
            console.error(error);
          });
        
    };
    document.head.appendChild(script);

    const link = document.createElement('link');
    link.rel = 'stylesheet';
    link.href = 'https://cesium.com/downloads/cesiumjs/releases/1.119/Build/Cesium/Widgets/widgets.css';
    document.head.appendChild(link);
}
