from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QWidget, QScrollArea, QVBoxLayout

from kit.component.kit_button import KitButton, KitIconButton
from kit.component.table.kit_table import KitTable, TableCellWidget


class CustomCell(TableCellWidget):
    def __init__(self):
        self.btn = KitButton()
        self.btn.clicked.connect(lambda: print(self.index_data, self.row_data))
        super().__init__()
        self.__init_widget()

    def __init_widget(self):
        self.layout = QVBoxLayout()
        self.layout.setContentsMargins(0, 0, 0, 0)
        self.layout.addWidget(self.btn)
        self.setLayout(self.layout)

    def setValue(self, index_data, row_data):
        self.btn.setText(str(index_data))

class TableExample(QScrollArea):

    def __init__(self, parent=None):
        super(TableExample, self).__init__(parent=parent)
        
        self.__init_widget()
        self.__init_slot()
        self.__init_qss()

    def __init_widget(self):
        self.main_widget = QWidget()
        self.setWidget(self.main_widget)
        layout = QVBoxLayout()
        self.main_widget.setLayout(layout)
        table = KitTable()
        table.setTableColumnProperty([
            {"display": "序号", "key": "id"},
            {"display": "姓名", "key": "name", 'width': 200, '_wrap': True},
            {"display": "年龄", "key": "age"},
            {"display": "身高", "key": "height", 'cell': type(CustomCell())},
        ])
        table_data = [
            {"id": 1, "name": "张三1289375091 27305781230975091", "age": 18, "height": 180},
            {"id": 2, "name": "李四", "age": 19, "height": 170},
            {"id": 3, "name": "王五", "age": 20, "height": 160},
            {"id": 4, "name": "赵六", "age": 21, "height": 150},
            {"id": 5, "name": "田七", "age": 22, "height": 140},
        ]
        table_data_2 = []
        for i in range(100):
            table_data_2.append({"id": i, "name": "张三" + str(i), "age": i, "height": 180})
        table_data_3 = []
        for i in range(80):
            table_data_3.append({"id": i * 2, "name": "李四" + str(i), "age": i * 2, "height": 170})
        table.setTableShowCheck(True)
        # table.setTablePageSum(2)
        table.setTableLeftFreeze(2)
        table.setBodyRowHeight(60)
        table.setTableData([])
        layout.addWidget(table)
        clear_btn = KitButton('清空')
        clear_btn.clicked.connect(lambda: table.setTableData([]))
        layout.addWidget(clear_btn)

        btn = KitButton('数据1')
        btn.clicked.connect(lambda: table.setTableData(table_data_2))
        layout.addWidget(btn)

        btn2 = KitButton('数据2')
        btn2.clicked.connect(lambda: table.setTableData(table_data_3))
        layout.addWidget(btn2)

        print_all = KitButton('打印全部数据')
        print_all.clicked.connect(lambda: print(table.table_data))
        layout.addWidget(print_all)
        table.freeze_table.table_body.setRowCount(1)

    def __init_slot(self):
        pass

    def __init_qss(self):
        self.setAttribute(Qt.WA_StyledBackground, True)

    def resizeEvent(self, a0) -> None:
        self.main_widget.resize(self.size())