import sys

from PyQt5.QtCore import Qt, QSize
from PyQt5.QtGui import QFontDatabase, QIcon
from PyQt5.QtWidgets import QPushButton, QGraphicsDropShadowEffect, QVBoxLayout, QWidget, QApplication, QSizePolicy

import config
from kit.component.kit_icon import KitIcon


class KitButton(QPushButton):

    # Button Type
    OutLined = 'outlined'
    Text = 'text'

    # Button Shape
    Round = 'round'
    Square = 'square'

    def __init__(self, text: str = "", icon: str = None, parent=None):
        super(KitButton, self).__init__(parent=parent)

        self._type = None
        self._shape = None
        self._style = None

        self.setText(text)
        if icon is not None:
            self.setIcon(KitIcon(icon).toIcon())

        self.__init_widget()
        self.__init_slot()
        self.__init_qss()

    def __init_widget(self):
        self.setFixedHeight(40)
        self.setIconSize(QSize(20, 20))

    def __init_slot(self):
        pass

    def __init_qss(self):
        self.setAttribute(Qt.WA_StyledBackground, True)

    def setType(self, button_type: str):
        self._type = button_type
        self.setProperty('type', button_type)
        self.style().polish(self)

    def setShape(self, button_shape: str):
        self._shape = button_shape
        self.setProperty('shape', button_shape)
        self.style().polish(self)

    def setIcon(self, icon: [QIcon, str]):
        if icon is None:
            return
        if type(icon) is QIcon:
            new_icon = icon
        elif type(icon) is str:
            new_icon = KitIcon(icon).toIcon()
        else:
            raise TypeError("Icon must be a QIcon or a str")
        super().setIcon(new_icon)

    def setShadow(self, if_shadow: bool = True):
        # creating a QGraphicsDropShadowEffect object
        if if_shadow:
            shadow = QGraphicsDropShadowEffect()
            shadow.setXOffset(0)
            shadow.setYOffset(2)
            # setting blur radius
            shadow.setBlurRadius(4)
            shadow.setColor(Qt.gray)
            # adding shadow to the button
            self.setGraphicsEffect(shadow)
        else:
            self.setGraphicsEffect(None)

    def sizeHint(self):
        return QSize(100, 40)


class KitIconButton(KitButton):
    def __init__(self, icon_str: str = None, parent=None):
        super(KitIconButton, self).__init__(parent=parent)
        self.setText("")
        self.setIcon(icon_str)

        self.__init_widget()

    def __init_widget(self):
        self.setFixedSize(40, 40)
